import type { IconType } from 'carbon-react/lib/components/icon/icon-type';
import type { SvgIconProps } from './components/SvgIcon/types';
import type { defaultLiterals } from './default-string-literals';
import type { Layout, Layouts, Responsive } from 'react-grid-layout';
export type ResponsiveLayout = Pick<Layout, 'i' | 'minW' | 'minH' | 'maxW' | 'maxH'> & {
    xxs: {
        x: number;
        y: number;
        w: number;
        h: number;
    };
    xs: {
        x: number;
        y: number;
        w: number;
        h: number;
    };
    sm: {
        x: number;
        y: number;
        w: number;
        h: number;
    };
    md: {
        x: number;
        y: number;
        w: number;
        h: number;
    };
    lg: {
        x: number;
        y: number;
        w: number;
        h: number;
    };
};
export type Cols = {
    xxs: number;
    xs: number;
    sm: number;
    md: number;
    lg: number;
};
export type BaseLayoutDefinition = {
    rowHeight: number;
    width: number;
    isDraggable?: boolean;
    isResizable?: boolean;
    displayAnchors?: boolean;
    editMode?: boolean;
    /** Optional URL where the layout is sent using a PUT method whenever the user saves the changes */
    url?: string;
};
export type FixedLayoutDefinition = BaseLayoutDefinition & {
    cols: number;
};
export type ResponsiveLayoutDefinition = BaseLayoutDefinition & {
    cols: Cols;
    breakpoints?: Cols;
};
export type WidgetType = 'bar-chart' | 'basic' | 'contact-card' | 'gauge' | 'horizontal-bar' | 'line-chart' | 'line' | 'multiple-indicators' | 'simple-list' | 'pie-chart' | 'preview' | 'progress-tracker' | 'separator' | 'simple-indicator' | 'status-report' | 'table' | 'tile-indicator' | 'tile-group-indicator' | 'treemap' | 'visual-process' | 'custom-widget' | 'quick-links';
export interface DropdownItem {
    i: string;
    label: string;
    icon?: IconType;
    action?: 'closeWidget' | 'editLayout';
    onClick?: () => void;
}
export interface DropdownItemDivider {
    i: string;
    isDivider?: boolean;
}
export interface DropdownDefinition {
    title?: string;
    items?: (DropdownItem | DropdownItemDivider)[];
}
export interface CallToActionDefinition {
    title: string;
    onClick: string | (() => void);
    target?: string;
    isDisabled?: boolean;
    isHidden?: boolean;
}
export interface BaseDragDropCanvasProps {
    locale: Locale;
    /** Renders the dashboard in editing mode */
    isEditMode?: boolean;
    /** Renders anchor elements on the side */
    areAnchorsDisplayed?: boolean;
    scrollTop?: number;
    highlightAnchorsFullSection?: boolean;
    /** If set, the header with the tabs and the dashboard settings is not rendered */
    isHeaderHidden?: boolean;
    stringLiterals: Partial<StringLiterals>;
    /** Triggered when the duplicate drop down header action is clicked by the user */
    onDuplicateAction?: () => void;
    /** Triggered when the delete header drop down action is clicked by the user */
    onDeleteAction?: () => void;
    /** Triggered when the share header drop down action is clicked by the user */
    onShareAction?: () => void;
    /** Triggered when the edit header drop down action is clicked by the user. If not set, it changes to editor mode. */
    onEditAction?: () => void;
    /** If true, the container padding is removed (0,0) instead of (24,24) */
    isContainerPaddingDisabled?: boolean;
}
export type GenericDragDropCanvasProps<T, L> = {
    layout: L;
    storeStateLayout?: L;
    widgets: T[];
    storeStateWidgets?: T[];
    onSavedData?: (newLayout: {
        layout: L;
        widgets: T[];
    }) => void;
    newItem?: Partial<T>;
};
export type FixedDragDropCanvasProps = GenericDragDropCanvasProps<AbstractWidget, FixedLayoutDefinition> & {
    /** This callback is triggered any time the widget change */
    onDataChange?: (newLayout: {
        layout: FixedLayoutDefinition;
        widgets: AbstractWidget[];
    }) => void;
    type?: 'fixed';
};
export type ResponsiveDragDropCanvasProps = GenericDragDropCanvasProps<AbstractResponsiveWidget, ResponsiveLayoutDefinition> & {
    /** This callback is triggered any time the widget change */
    onDataChange?: (newLayout: {
        layout: ResponsiveLayoutDefinition;
        widgets: AbstractResponsiveWidget[];
        breakpoint: Breakpoint;
    }) => void;
    onBreakpointChange?: OnBreakpointChange;
    type: 'responsive';
};
export type DragDropCanvasProps = BaseDragDropCanvasProps & (FixedDragDropCanvasProps | ResponsiveDragDropCanvasProps);
export type Breakpoint = 'xxs' | 'xs' | 'sm' | 'md' | 'lg';
export type OnBreakpointChange = NonNullable<React.ComponentProps<typeof Responsive>['onBreakpointChange']>;
export type OnLayoutChange = (currentLayout: Layout[], allLayouts: Layouts, type: 'drag' | 'resize' | 'fix' | 'update') => void;
export type BaseDragDropProps = {
    isEditMode: boolean;
    locale: Locale;
    stringLiterals: StringLiterals;
    onWidgetRemoved: (i: string) => void;
    isContainerPaddingDisabled?: boolean;
};
export type FixedDragDropProps = {
    type: 'fixed';
    layout: FixedLayoutDefinition;
    widgets: AbstractWidget[];
    onWidgetLayoutChanged: (layout: Layout[]) => void;
    onNewItemAdded?: (newItem: Layout) => void;
    newItem?: Partial<AbstractWidget>;
};
export type ResponsiveDragDropProps = {
    type: 'responsive';
    layout: ResponsiveLayoutDefinition;
    widgets: AbstractResponsiveWidget[];
    onWidgetLayoutChanged: (currentLayout: Layout[], allLayouts: ReactGridLayout.Layouts, breakpoint: Breakpoint) => void;
    onNewItemAdded?: ({ newItem, breakpoint }: {
        newItem: Layout;
        breakpoint: Breakpoint;
    }) => void;
    newItem?: Partial<AbstractResponsiveWidget>;
    onBreakpointChange?: OnBreakpointChange;
};
export type Optional<T extends object, K extends keyof T = keyof T> = Omit<T, K> & Partial<Pick<T, K>>;
export type InternalDragDropProps = BaseDragDropProps & (ResponsiveDragDropProps | FixedDragDropProps);
export type DragDropProps = Optional<InternalDragDropProps, 'type'>;
interface BaseWidget {
    type: WidgetType;
    i: string;
    title?: string;
    description?: string;
    icon?: SvgIconProps;
    dropdown?: DropdownDefinition;
    callToActions?: Dict<CallToActionDefinition>;
    url?: string;
    showLoader?: boolean;
    isLoading?: boolean;
    isAiGenerated?: boolean;
}
export interface AbstractResponsiveWidget<T = any> extends BaseWidget, ResponsiveLayout {
    data?: T;
}
export interface AbstractWidget<T = any> extends BaseWidget, Layout {
    data?: T;
}
export type Locale = 'en-US' | 'en-GB' | 'fr-FR' | 'es-ES' | 'pt-PT' | 'pt-BR' | 'ar-SA' | 'de-DE' | 'it-IT' | 'pl-PL' | 'zh-CN';
export type DashboardValueOrCallback<T> = T | ((i: string | number) => T);
export interface Dict<T> {
    [key: string]: T;
}
export type TranslationKey = keyof DefaultLiterals | (string & {});
type DefaultLiterals = typeof defaultLiterals;
export type StringLiterals = {
    [K in keyof DefaultLiterals]: string;
} & Dict<string | object>;
export declare const NEW_WIDGET_ID = "__NEW_WIDGET";
export declare const PENDING_WIDGET_ID = "__PENDING_ITEM";
export type Currency = 'AED' | 'AFN' | 'ALL' | 'AMD' | 'ANG' | 'AOA' | 'ARS' | 'AUD' | 'AWG' | 'AZN' | 'BAM' | 'BBD' | 'BDT' | 'BGN' | 'BHD' | 'BIF' | 'BMD' | 'BND' | 'BOB' | 'BOV' | 'BRL' | 'BSD' | 'BTN' | 'BWP' | 'BYN' | 'BZD' | 'CAD' | 'CDF' | 'CHE' | 'CHF' | 'CHW' | 'CLF' | 'CLP' | 'CNY' | 'COP' | 'COU' | 'CRC' | 'CUC' | 'CUP' | 'CVE' | 'CZK' | 'DJF' | 'DKK' | 'DOP' | 'DZD' | 'EGP' | 'ERN' | 'ETB' | 'EUR' | 'FJD' | 'FKP' | 'GBP' | 'GEL' | 'GHS' | 'GIP' | 'GMD' | 'GNF' | 'GTQ' | 'GYD' | 'HKD' | 'HNL' | 'HRK' | 'HTG' | 'HUF' | 'IDR' | 'ILS' | 'INR' | 'IQD' | 'IRR' | 'ISK' | 'JMD' | 'JOD' | 'JPY' | 'KES' | 'KGS' | 'KHR' | 'KMF' | 'KPW' | 'KRW' | 'KWD' | 'KYD' | 'KZT' | 'LAK' | 'LBP' | 'LKR' | 'LRD' | 'LSL' | 'LYD' | 'MAD' | 'MDL' | 'MGA' | 'MKD' | 'MMK' | 'MNT' | 'MOP' | 'MRU' | 'MUR' | 'MVR' | 'MWK' | 'MXN' | 'MXV' | 'MYR' | 'MZN' | 'NAD' | 'NGN' | 'NIO' | 'NOK' | 'NPR' | 'NZD' | 'OMR' | 'PAB' | 'PEN' | 'PGK' | 'PHP' | 'PKR' | 'PLN' | 'PYG' | 'QAR' | 'RON' | 'RSD' | 'RUB' | 'RWF' | 'SAR' | 'SBD' | 'SCR' | 'SDG' | 'SEK' | 'SGD' | 'SHP' | 'SLE' | 'SLL' | 'SOS' | 'SRD' | 'SSP' | 'STN' | 'SVC' | 'SYP' | 'SZL' | 'THB' | 'TJS' | 'TMT' | 'TND' | 'TOP' | 'TRY' | 'TTD' | 'TWD' | 'TZS' | 'UAH' | 'UGX' | 'USD' | 'USN' | 'UYI' | 'UYU' | 'UYW' | 'UZS' | 'VED' | 'VES' | 'VND' | 'VUV' | 'WST' | 'XAF' | 'XAG' | 'XAU' | 'XBA' | 'XBB' | 'XBC' | 'XBD' | 'XCD' | 'XDR' | 'XOF' | 'XPD' | 'XPF' | 'XPT' | 'XSU' | 'XTS' | 'XUA' | 'XXX' | 'YER' | 'ZAR' | 'ZMW' | 'ZWL';
export type CurrencySymbol = '$' | '€' | '£' | '¥';
export type CurrencyOrSymbol = Currency | CurrencySymbol;
export {};
