import type { Locale, StringLiterals } from '../types';
import type { CollectionDateFilter, PeriodDetails } from '../components/shared/DateFilter/types';
import { DateFilterPeriodType } from '../components/shared/DateFilter/types';
export declare const COLUMN_COUNT = 3;
export declare const ROW_HEIGHT = 50;
export declare const PERIOD_SELECTOR_HEIGHT = 340;
export declare function getLocalCurrentDateString(): string;
export interface GetPeriodsArgs {
    type: DateFilterPeriodType;
    locale: Locale;
    dateFilter?: CollectionDateFilter;
    stringLiterals: StringLiterals;
}
/**
 * This function computes all potential periods between the max and min dates depending on the type of period
 * @param type
 * @param dateFilter
 */
export declare const getPeriods: (({ type, locale, dateFilter, stringLiterals }: GetPeriodsArgs) => PeriodDetails[]) & import("lodash").MemoizedFunction;
export declare const getRowsFromPeriods: (periods: PeriodDetails[]) => Array<string | PeriodDetails[]>;
export declare function findPeriodByDate(dateString: string, type: DateFilterPeriodType, locale: Locale, stringLiterals: StringLiterals): PeriodDetails | null;
export declare function getNeighboringPeriod(currentPeriod: PeriodDetails, type: DateFilterPeriodType, locale: Locale, stringLiterals: StringLiterals, direction: 1 | -1): PeriodDetails;
export declare function getInitialRowScrollPosition(selectedPeriod: PeriodDetails | null, rows: Array<string | PeriodDetails[]>): number;
