import type { IconType } from 'carbon-react/lib/components/icon/icon-type';
import './TileIndicator.scss';
import type { Locale, Currency, StringLiterals } from '../../types';
export interface TileIndicatorProps {
    color: string;
    currencyIndicator?: CurrencyIndicator;
    icon: IconType;
    isAiGenerated?: boolean;
    locale?: Locale;
    onClick?: () => void;
    stringLiterals: StringLiterals;
    title?: string;
    value?: string;
    valueType?: ValueType;
}
export type ValueType = 'currency' | 'text';
export type CurrencyIndicator = {
    value?: number;
    currencyCode?: Currency;
};
export default function TileIndicator({ color, currencyIndicator, icon, isAiGenerated, locale, onClick, stringLiterals, title, value, valueType, }: TileIndicatorProps): JSX.Element;
