import type { CallToActionDefinition, Dict, Locale, StringLiterals } from '../../types';
import type { WidgetCollectionItem, WidgetCollectionItemDefinition } from '../shared/Collection/types';
import type { FilterLineFilterConfig } from '../shared/FilterLine';
export interface PiePartProps extends WidgetCollectionItem {
    _id: string;
    legendLabel?: string;
    value: number;
    color?: string;
}
export interface PieChartProps {
    pieChartData: PiePartProps[];
    isDonut?: boolean;
    stringLiterals: StringLiterals;
    chartLabel?: string;
    hasCardView?: boolean;
    collectionItemDefinition?: WidgetCollectionItemDefinition;
    locale: Locale;
    filter?: FilterLineFilterConfig;
    callToActions?: Dict<CallToActionDefinition>;
}
export interface GetCellColorParameters {
    piePartIndex: number;
    defaultColors: string[];
    piePart: PiePartProps;
}
export interface RenderCustomizedLabelParameters {
    cx: number;
    cy: number;
    midAngle: number;
    innerRadius: number;
    outerRadius: number;
    percent: number;
}
export declare enum PieChartViewMode {
    CHART = "chart",
    GRID = "grid"
}
