import type { CSSProperties } from 'react';
import React from 'react';
import type { useAnchor } from 'react-charts/lib/hooks/useAnchor';
import type { Axis, Datum, ResolvedChartOptions } from 'react-charts';
export type TooltipRendererProps<TDatum> = {
    focusedDatum: Datum<TDatum> | null;
    getOptions: () => ResolvedChartOptions<TDatum>;
    primaryAxis: Axis<TDatum>;
    secondaryAxes: Axis<TDatum>[];
    secondaryAxis: Axis<TDatum>;
    getDatumStyle: (datum: Datum<TDatum>) => CSSProperties;
    anchor: ReturnType<typeof useAnchor>;
    children: React.ReactNode;
    backgroundColor?: string;
};
export default function tooltipRenderer<TDatum>(props: TooltipRendererProps<TDatum>): JSX.Element;
export declare function TooltipRenderer<TDatum>(props: TooltipRendererProps<TDatum>): JSX.Element | null;
