declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        Operation as Node$Operation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        integer,
    } from '@sage/xtrem-client';
    export interface SysDefinitionLevel3$Enum {
        folder: 1;
        company: 2;
        site: 3;
        user: 4;
        legislation: 5;
    }
    export type SysDefinitionLevel3 = keyof SysDefinitionLevel3$Enum;
    export interface SysFieldType1$Enum {
        alphanumeric: 1;
        numeric: 2;
        date: 3;
        localMenu: 4;
    }
    export type SysFieldType1 = keyof SysFieldType1$Enum;
    export interface SysModuleTable$Enum {
        supervisor: 1;
        financials: 2;
        aparAccounting: 3;
        external: 4;
        sales: 5;
        purchasing: 6;
        stock: 7;
        manufacturing: 8;
        commonData: 9;
        development: 10;
        sageX3Internals: 11;
        helpDesk: 12;
        crmActivities: 13;
        fixedAssets: 14;
        humanResourcesAdministration: 15;
        moduleSpe1: 16;
        moduleSpe2: 17;
        moduleSpe3: 18;
        moduleSpe4: 19;
        humanCapitalManagement: 20;
    }
    export type SysModuleTable = keyof SysModuleTable$Enum;
    export interface SysSequenceNumberType$Enum {
        alphanumeric: 1;
        numeric: 2;
    }
    export type SysSequenceNumberType = keyof SysSequenceNumberType$Enum;
    export interface SysTypeOfDependency$Enum {
        none: 1;
        reverse: 2;
        sizing: 3;
        formula: 4;
    }
    export type SysTypeOfDependency = keyof SysTypeOfDependency$Enum;
    export interface SysTypesOfActivityCode$Enum {
        functional: 1;
        sizing: 2;
        localization: 3;
    }
    export type SysTypesOfActivityCode = keyof SysTypesOfActivityCode$Enum;
    export interface SysFunctionVariables extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        internal: string;
        value: string;
        variable: string;
    }
    export interface SysFunctionVariablesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        internal?: string;
        value?: string;
        variable?: string;
    }
    export interface SysFunctionVariablesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        internal: string;
        value: string;
        variable: string;
    }
    export interface SysFunctionVariables$Lookups {
        activityCode: QueryOperation<SysActivityCode>;
    }
    export interface SysFunctionVariables$Operations {
        query: QueryOperation<SysFunctionVariables>;
        read: ReadOperation<SysFunctionVariables>;
        aggregate: {
            read: AggregateReadOperation<SysFunctionVariables>;
            query: AggregateQueryOperation<SysFunctionVariables>;
        };
        lookups(dataOrId: string | { data: SysFunctionVariablesInput }): SysFunctionVariables$Lookups;
        getDefaults: GetDefaultsOperation<SysFunctionVariables>;
    }
    export interface SysGeneralParameter extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        definitionLevel: SysDefinitionLevel3;
    }
    export interface SysGeneralParameterInput extends ClientNodeInput {
        code?: string;
        definitionLevel?: SysDefinitionLevel3;
    }
    export interface SysGeneralParameterBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        definitionLevel: SysDefinitionLevel3;
    }
    export interface SysGeneralParameter$Queries {
        readByUserParameterValueString: Node$Operation<
            {
                parameters: {
                    code: string;
                    userCode?: string;
                    site?: string;
                    defintionLevel?: SysDefinitionLevel3;
                };
            },
            string
        >;
        readByUserParameterValueDate: Node$Operation<
            {
                parameters: {
                    code: string;
                    userCode?: string;
                    site?: string;
                    defintionLevel?: SysDefinitionLevel3;
                };
            },
            string | null
        >;
        readByUserParameterValueDecimal: Node$Operation<
            {
                parameters: {
                    code: string;
                    userCode?: string;
                    site?: string;
                    defintionLevel?: SysDefinitionLevel3;
                };
            },
            string | null
        >;
        readByUserParameterValueInteger: Node$Operation<
            {
                parameters: {
                    code: string;
                    userCode?: string;
                    site?: string;
                    defintionLevel?: SysDefinitionLevel3;
                };
            },
            integer
        >;
        readByUserParameterValueBoolean: Node$Operation<
            {
                parameters: {
                    code: string;
                    userCode?: string;
                    site?: string;
                    defintionLevel?: SysDefinitionLevel3;
                };
            },
            boolean
        >;
        readParameterValueString: Node$Operation<
            {
                parameters: {
                    parameterCode: string;
                    level?: SysDefinitionLevel3;
                    code?: string;
                };
            },
            string
        >;
        readParameterValueDate: Node$Operation<
            {
                parameters: {
                    parameterCode: string;
                    level?: SysDefinitionLevel3;
                    code?: string;
                };
            },
            string | null
        >;
        readParameterValueDecimal: Node$Operation<
            {
                parameters: {
                    parameterCode: string;
                    level?: SysDefinitionLevel3;
                    code?: string;
                };
            },
            string
        >;
        readParameterValueInteger: Node$Operation<
            {
                parameters: {
                    parameterCode: string;
                    level?: SysDefinitionLevel3;
                    code?: string;
                };
            },
            integer
        >;
        readParameterValueBoolean: Node$Operation<
            {
                parameters: {
                    parameterCode: string;
                    level?: SysDefinitionLevel3;
                    code?: string;
                };
            },
            boolean
        >;
    }
    export interface SysGeneralParameter$Operations {
        query: QueryOperation<SysGeneralParameter>;
        read: ReadOperation<SysGeneralParameter>;
        aggregate: {
            read: AggregateReadOperation<SysGeneralParameter>;
            query: AggregateQueryOperation<SysGeneralParameter>;
        };
        queries: SysGeneralParameter$Queries;
        getDefaults: GetDefaultsOperation<SysGeneralParameter>;
    }
    export interface SysGeneralParametersData extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysGeneralParametersDataInput extends ClientNodeInput {}
    export interface SysGeneralParametersDataBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysGeneralParametersData$Operations {
        query: QueryOperation<SysGeneralParametersData>;
        read: ReadOperation<SysGeneralParametersData>;
        aggregate: {
            read: AggregateReadOperation<SysGeneralParametersData>;
            query: AggregateQueryOperation<SysGeneralParametersData>;
        };
        getDefaults: GetDefaultsOperation<SysGeneralParametersData>;
    }
    export interface SysMiscellaneousTablesColumns extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
    }
    export interface SysMiscellaneousTablesColumnsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
    }
    export interface SysMiscellaneousTablesColumnsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
    }
    export interface SysMiscellaneousTablesColumns$Operations {
        query: QueryOperation<SysMiscellaneousTablesColumns>;
        read: ReadOperation<SysMiscellaneousTablesColumns>;
        aggregate: {
            read: AggregateReadOperation<SysMiscellaneousTablesColumns>;
            query: AggregateQueryOperation<SysMiscellaneousTablesColumns>;
        };
        getDefaults: GetDefaultsOperation<SysMiscellaneousTablesColumns>;
    }
    export interface SysPackage extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        name: string;
        description: string;
        isActive: boolean;
    }
    export interface SysPackageInput extends ClientNodeInput {
        name?: string;
        description?: string;
        isActive?: boolean | string;
    }
    export interface SysPackageBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        name: string;
        description: string;
        isActive: boolean;
    }
    export interface SysPackage$Operations {
        query: QueryOperation<SysPackage>;
        read: ReadOperation<SysPackage>;
        aggregate: {
            read: AggregateReadOperation<SysPackage>;
            query: AggregateQueryOperation<SysPackage>;
        };
        getDefaults: GetDefaultsOperation<SysPackage>;
    }
    export interface SysUser extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        name: string;
        nameDescription: string;
        code: string;
        displayName: string;
        photo: BinaryStream;
    }
    export interface SysUserInput extends ClientNodeInput {
        name?: string;
        nameDescription?: string;
        code?: string;
    }
    export interface SysUserBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        name: string;
        nameDescription: string;
        code: string;
        displayName: string;
        photo: BinaryStream;
    }
    export interface SysUser$Lookups {
        functionProfile: QueryOperation<SysUserFunctionProfile>;
    }
    export interface SysUser$Operations {
        query: QueryOperation<SysUser>;
        read: ReadOperation<SysUser>;
        aggregate: {
            read: AggregateReadOperation<SysUser>;
            query: AggregateQueryOperation<SysUser>;
        };
        lookups(dataOrId: string | { data: SysUserInput }): SysUser$Lookups;
        getDefaults: GetDefaultsOperation<SysUser>;
    }
    export interface SysUtility extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysUtilityInput extends ClientNodeInput {}
    export interface SysUtilityBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysUtility$Queries {
        parseKey: Node$Operation<
            {
                input: string;
            },
            {
                nodeName: string;
                key: string;
            }
        >;
    }
    export interface SysUtility$Operations {
        queries: SysUtility$Queries;
        getDefaults: GetDefaultsOperation<SysUtility>;
    }
    export interface Package {
        '@sage/xtrem-x3-system-utils/SysFunctionVariables': SysFunctionVariables$Operations;
        '@sage/xtrem-x3-system-utils/SysGeneralParameter': SysGeneralParameter$Operations;
        '@sage/xtrem-x3-system-utils/SysGeneralParametersData': SysGeneralParametersData$Operations;
        '@sage/xtrem-x3-system-utils/SysMiscellaneousTablesColumns': SysMiscellaneousTablesColumns$Operations;
        '@sage/xtrem-x3-system-utils/SysPackage': SysPackage$Operations;
        '@sage/xtrem-x3-system-utils/SysUser': SysUser$Operations;
        '@sage/xtrem-x3-system-utils/SysUtility': SysUtility$Operations;
    }
    export interface GraphApi extends Package, SageXtremAppMetadata$Package {}
}
declare module '@sage/xtrem-x3-system-utils-api' {
    export type * from '@sage/xtrem-x3-system-utils-api-partial';
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/xtrem-x3-system-utils-api';
    export interface GraphApi extends GraphApiExtension {}
}
