// From file: @sage/xtrem-filter-utils/build/index.d.ts
declare module '@sage/xtrem-filter-utils/index' {
	export * from '@sage/xtrem-filter-utils/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-filter-utils/build/lib/index.d.ts
declare module '@sage/xtrem-filter-utils/lib/index' {
	import { FilterProperty, FilterType, GraphQLTypes, LocalizeLocale, NodeDetails } from '@sage/xtrem-shared';
	export const EMPTIABLE_GRAPHQL_TYPES: GraphQLTypes[];
	export const geFilterQuery: ({ filterType, filterValue, parameter, type, }: {
	    filterType: FilterType<any>;
	    filterValue: any;
	    parameter?: boolean;
	    type: NodeDetails["type"];
	}) => any;
	export const timeFrameValues: readonly ["same-month", "same-year", "previous-month", "previous-year", "last-7-days", "last-30-days", "previous-day", "same-day", "previous-week", "same-week", "next-day", "next-week", "next-month", "next-year"];
	export type TimeFrameValues = (typeof timeFrameValues)[number];
	export function getFilterObject({ filters, locale, }: {
	    filters: (Pick<FilterProperty, 'filterType' | 'parameter' | 'filterValue' | 'id'> & {
	        data: Pick<FilterProperty['data'], 'type'>;
	    })[];
	    locale?: LocalizeLocale;
	}): any;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/xtrem-filter-utils' {
	export * from '@sage/xtrem-filter-utils/index';
}
