## Common Issues and Solutions

### Missing Decorator Properties

````typescript
### Common Issues and Solutions

#### Missing Decorator Properties
```typescript
// ❌ Missing required properties
@decorators.node<ShowCaseProduct>({})
export class ShowCaseProduct extends Node {}

// ✅ Correct with required properties
@decorators.node<ShowCaseProduct>({
    storage: 'sql',
    canCreate: true,
    canRead: true,
    canUpdate: true,
    canDelete: true,
    isPublished: true,
    indexes: [{ orderBy: { product: 1 }, isUnique: true }]
})
export class ShowCaseProduct extends Node {}
````

### Import Issues

```typescript
// ❌ Incorrect import
import { Page } from '@sage/xtrem-ui';

// ✅ Correct import
import * as ui from '@sage/xtrem-ui';
export class MyPage extends ui.Page {}
```

### Property Type Issues

```typescript
// ❌ Incorrect property declaration
@decorators.stringProperty<ShowCaseProduct, 'product'>({
    isStored: true,
    isPublished: true,
})
product: string; // Missing Promise<>

// ✅ Correct property declaration
@decorators.stringProperty<ShowCaseProduct, 'product'>({
    isStored: true,
    isPublished: true,
})
readonly product: Promise<string>;
```

### Reference Property Configuration

```typescript
// ❌ Missing node configuration
@decorators.referenceProperty<ShowCaseProduct, 'provider'>({
    isStored: true,
    isPublished: true,
})
readonly provider: Reference<ShowCaseProvider>;

// ✅ Correct reference configuration
@decorators.referenceProperty<ShowCaseProduct, 'provider'>({
    isStored: true,
    isPublished: true,
    isNullable: true,
    node: () => xtremShowCase.nodes.ShowCaseProvider,
})
readonly provider: Reference<xtremShowCase.nodes.ShowCaseProvider | null>;
```

### Page Parent Issues

```typescript
// ❌ Missing parent function
@ui.decorators.textField<ShowCaseProduct>({
    title: 'Product'
})
product: ui.fields.Text;

// ✅ Correct with parent function
@ui.decorators.textField<ShowCaseProduct>({
    parent() {
        return this.block;
    },
    title: 'Product'
})
product: ui.fields.Text;
```

