## Framework Components

This section covers the main building blocks for creating Xtrem applications - entities, user interfaces, security, and feature management.

### Nodes (Entities)

Nodes represent business entities and are the foundation of data modeling in Xtrem. They define the structure, validation, and behavior of business objects.

**Basic Node Structure:**

```typescript
@decorators.node<ShowCaseProduct>({
    storage: 'sql',
    canCreate: true,
    canDelete: true,
    canRead: true,
    canUpdate: true,
    isPublished: true,
})
export class ShowCaseProduct extends Node {
    // Properties defined with decorators
}
```

See the Property Decorators section above for detailed property definitions.

### Pages (User Interface)

Pages provide the user interface for interacting with business entities. They combine UI field decorators to create forms and views.

**Basic Page Structure:**

```typescript
@ui.decorators.page<ShowCaseProduct, ShowCaseProductNode>({
    title: 'ShowCase - Product',
    node: '@sage/xtrem-show-case/ShowCaseProduct',
    menuItem: applicationPages,
})
export class ShowCaseProduct extends ui.Page<GraphApi> {
    // UI fields defined with decorators
}
```

See the UI Field Decorators section above for detailed field definitions.

### Activities (Security)

Activities define security permissions and access control for nodes. They establish what operations users can perform on different data entities.

**Basic Activity Structure:**

```typescript
import { Activity } from '@sage/xtrem-core';

export const showCaseProvider = new Activity({
    __filename,
    permissions: ['manage'],
    operationGrants: {
        manage: [
            {
                operations: ['create', 'read', 'update', 'delete'],
                on: [() => ShowCaseProvider],
            },
        ],
    },
});
```

### Service Options (Feature Management)

Service Options control which features are available in your application. They provide flexible feature toggle functionality.

**Basic Service Option:**

```typescript
import { ServiceOption } from '@sage/xtrem-core';

export const showCaseDiscountOption = new ServiceOption({
    __filename,
    status: 'experimental',
    description: 'showCase discount option',
    isSubscribable: false,
    isHidden: false,
});
```

