// eslint.config.mjs (ESLint v9+)
import { defineConfig, globalIgnores } from 'eslint/config';
import globals from 'globals';
import baseConfig from '../../eslint-base.config.mjs';

export default defineConfig([
    globalIgnores(['build/**', 'tmp/**', 'node_modules/**', '**/coverage', '**/i18n/*.json']),
    {
        languageOptions: {
            parserOptions: {
                parser: '@typescript-eslint/parser',
                projectService: true,
                tsconfigRootDir: import.meta.dirname,
                project: ['tsconfig.json'],
                extraFileExtensions: ['.json'],
            },
        },
    },
    ...baseConfig,
    {
        files: ['**/*.js'],
        rules: {
            '@typescript-eslint/no-require-imports': 'off',
        },
    },
    {
        files: ['**/*.ts'],
        rules: {
            // To review: ESLint V9 migration (all the following are temporarily disabled)
            '@typescript-eslint/no-redundant-type-constituents': 'off',
            '@typescript-eslint/no-require-imports': 'off',
            '@typescript-eslint/no-shadow': 'off',
            '@typescript-eslint/no-unused-vars': 'off',
            '@typescript-eslint/require-await': 'off',
            'n/global-require': 'off',
            'no-console': 'off',
            'no-promise-executor-return': 'off',
            null: 'off',
        },
    },
    // config envs
    {
        languageOptions: {
            globals: { ...globals.browser, ...globals.node },
        },
    },
]);
