export type AnyNonNullableValue = boolean | string | number | object | AnyValue[];
export type AnyValue = AnyNonNullableValue | null | undefined;
export type AnyRecord = {
    [key: string]: AnyValue;
};
export type AsyncResponse<T extends unknown | void> = T | PromiseLike<T>;
export type NestedMaybePromised = {
    [key: string]: NestedMaybePromised | AsyncResponse<AnyValue>;
};
export type UnPromised<T> = T extends Promise<infer U> ? U : T;
export type UnPromisedMap<T extends object> = {
    [K in keyof T]: UnPromised<T[K]>;
};
export type Promised<T extends {
    [K in keyof T]: AnyValue;
}> = {
    [K in keyof T]: Promise<T[K]>;
};
/** silly void promise to keep sonar happy */
export declare const voidPromise: Promise<void>;
//# sourceMappingURL=promise-markers.d.ts.map