"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAsync = getAsync;
const async_array_1 = require("./async-array");
/**
 * Similar to lodash.get, get a value from an object from an attribute path, regardless if the value is a Promise, or
 * if any of the sub-key values are Promises.
 */
function getAsync(source, path) {
    const pathList = path.split('.');
    return (0, async_array_1.asyncArray)(pathList).reduce(async (currentVal, key) => {
        if (currentVal == null)
            return currentVal;
        // eslint-disable-next-line @typescript-eslint/return-await, no-return-await
        return await currentVal[key];
    }, source);
}
//# sourceMappingURL=get-async.js.map