import { AsyncArrayLike, AsyncArrayReader } from './async-array';
import { AnyValue, AsyncResponse } from './promise-markers';
/**
 * Async reader interface. Implemented by AsyncGenericReader and AsyncArrayReader
 */
export interface AsyncReader<T extends AnyValue> extends AsyncArrayLike<T> {
    map<R extends AnyValue>(body: (item: T, i: number) => AsyncResponse<R>): AsyncReader<R>;
    filter(body: (item: T) => AsyncResponse<boolean>): AsyncReader<T>;
    get readCount(): number;
    read: () => AsyncResponse<T | undefined>;
    stop: () => AsyncResponse<void>;
    readAll(): Promise<T[]>;
    toAsyncGenerator(): AsyncGenerator<T>;
}
/**
 * Constructor options for AsyncGenericReader
 */
export interface AsyncGenericReaderOptions<T extends AnyValue> {
    read: () => AsyncResponse<T | undefined>;
    stop: () => AsyncResponse<void>;
}
/**
 * Generic Implementation of AsyncReader interface
 */
export declare class AsyncGenericReader<T extends AnyValue> implements AsyncReader<T> {
    #private;
    private readonly options;
    constructor(options: AsyncGenericReaderOptions<T>);
    get readCount(): number;
    read(): Promise<T | undefined>;
    stop(): Promise<void>;
    forEach(body: (item: T, i: number) => AsyncResponse<void>): Promise<void>;
    map<R extends AnyValue>(body: (item: T, i: number) => AsyncResponse<R>): AsyncReader<R>;
    filter(body: (item: T) => AsyncResponse<boolean>): AsyncReader<T>;
    reduce<R extends AnyValue>(body: (prev: R, item: T) => AsyncResponse<R>, initial: R): Promise<R>;
    find(body: (item: T, i: number) => AsyncResponse<boolean>): Promise<T | undefined>;
    findIndex(body: (item: T, i: number) => AsyncResponse<boolean>): Promise<number>;
    some(body: (item: T) => AsyncResponse<boolean>): Promise<boolean>;
    every(body: (item: T) => AsyncResponse<boolean>): Promise<boolean>;
    readAll(): Promise<T[]>;
    sort(compare: (elt1: T, elt2: T) => AsyncResponse<number>): AsyncReader<T>;
    toAsyncGenerator(): AsyncGenerator<T>;
}
export declare function createAsyncGenerator<T extends AnyValue>(reader: AsyncGenericReader<T> | AsyncArrayReader<T>): AsyncGenerator<T>;
//# sourceMappingURL=async-reader.d.ts.map