// eslint.config.mjs (ESLint v9+)
import globals from 'globals';
import baseConfig from '../../eslint-base.config.mjs';

import { defineConfig, globalIgnores } from 'eslint/config';

export default defineConfig([
    globalIgnores([
        'build/**',
        'tmp/**',
        'node_modules/**',
        '**/coverage',
        '**/i18n/*.json',
        'test/fixtures/bundles/*',
        'data/exports/',
    ]),
    {
        languageOptions: {
            parserOptions: {
                parser: '@typescript-eslint/parser',
                projectService: true,
                tsconfigRootDir: import.meta.dirname,
                project: 'tsconfig.json',
                extraFileExtensions: ['.json'],
            },
        },
    },

    ...baseConfig,
    {
        files: ['lib/**/*.ts'],
        rules: {
            // We enforce this explicit return types in this package
            // because it defines the framework API and this API must be
            // stable and easy to review.
            '@typescript-eslint/explicit-function-return-type': [
                'error',
                {
                    allowExpressions: true,
                },
            ],
            'no-plusplus': 'off', // Allow ++ and -- operators
            'react/forbid-prop-types': 'off',
        },
    },
    {
        files: ['**/*.js'],
        rules: {
            '@typescript-eslint/no-require-imports': 'off',
        },
    },
    // config envs
    {
        languageOptions: {
            globals: { ...globals.browser, ...globals.node },
        },
    },
]);
