/** Mock options provided by a workflow scenario */
export interface WorkflowMockOptions {
    path: string;
    calls: {
        input: any;
        output: any;
    }[];
}
export declare abstract class WorkflowMock {
    readonly options: WorkflowMockOptions;
    constructor(options: WorkflowMockOptions);
    abstract execute<T>(body: () => Promise<T>): Promise<T>;
    static loadMock(options: WorkflowMockOptions): Promise<WorkflowMock>;
    static run<T>(mocks: WorkflowMockOptions[] | undefined, body: () => Promise<T>): Promise<T>;
}
//# sourceMappingURL=workflow-mock.d.ts.map