/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.RecordPaging=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),lodash_1=require("lodash"),runtime_1=require("../runtime"),system_properties_1=require("../runtime/system-properties"),ts_api_1=require("../ts-api"),types_1=require("../types");class RecordPaging{static composeComparators(r,e){return async(t,a)=>{const n=await r(t,a);if(0!==n)return n;return e(t,a)}}static async compileOrderBy(r,e,t,a){let out=()=>0;return await(0,xtrem_async_helper_1.asyncArray)(Object.keys(t)).forEach(async(n,i)=>{const o=t[n];let s;const p=e.findProperty(n,{includeSystemProperties:true});if(-1===o||1===o)s=async(e,t)=>{if(e===t)return 0;if(null==e)return null==t?0:-o;if(null==t)return o;const n=await a(r,p,e),i=await a(r,p,t);return(0,runtime_1.valueComparator)(n,i,r.locales)*o};else{if(!p.isForeignNodeProperty())throw new Error(`Invalid orderBy property: ${n}`);const e=await RecordPaging.compileOrderBy(r,p.targetFactory,o,a);s=(r,t)=>e(r[n],t[n])}if(0===i)out=s;else out=RecordPaging.composeComparators(out,s)}),out}static converter(r){const pfalse=()=>false,ptrue=()=>true,valueToArray=r=>{if(Array.isArray(r))return r;return[r]},reTest=r=>e=>"string"==typeof e&&r.test(e),not=r=>e=>!r(e),or=r=>{if(0===r.length)return pfalse;if(1===r.length)return r[0];return e=>r.some(r=>r(e))},and=r=>{if(0===r.length)return ptrue;if(1===r.length)return r[0];return e=>r.every(r=>r(e))},compose=(r,e)=>t=>r(e(t)),deref=r=>e=>{if(null==e)return;const t=e[r];return"function"==typeof t?t():t},e={_eq:e=>t=>0===(0,runtime_1.valueComparator)(t,e,r),_ne:e=>t=>0!==(0,runtime_1.valueComparator)(t,e,r),_gt:e=>t=>(0,runtime_1.valueComparator)(t,e,r)>0,_gte:e=>t=>(0,runtime_1.valueComparator)(t,e,r)>=0,_lt:e=>t=>(0,runtime_1.valueComparator)(t,e,r)<0,_lte:e=>t=>(0,runtime_1.valueComparator)(t,e,r)<=0,_in:e=>t=>valueToArray(e).some(e=>0===(0,runtime_1.valueComparator)(e,t,r)),_nin:e=>t=>valueToArray(e).every(e=>0!==(0,runtime_1.valueComparator)(e,t,r)),_and:r=>and(valueToArray(r).map(cvt)),_or:r=>or(valueToArray(r).map(cvt)),_nor:r=>not(or(valueToArray(r).map(cvt))),_not:r=>not(cvt(r)),_exists:r=>e=>("string"==typeof r||"number"==typeof r)&&null!=e&&"object"==typeof e&&r in e,_type:r=>e=>typeof e===r,_mod:r=>e=>Array.isArray(r)&&"number"==typeof r[0]&&"number"==typeof e&&e%r[0]===r[1],_regex:(r,e)=>{if("string"!=typeof r)throw new xtrem_shared_1.LogicError("invalid regex type:"+typeof r);const t=new RegExp(r,e._options||"");return r=>"string"==typeof r&&t.test(r)}},walk=r=>{const e=r.indexOf(".");if(e>=0)return compose(walk(r.substring(e+1)),walk(r.substring(0,e)));return deref(r)},isQuantifiedBy=(r,e)=>e in r,quantifiedFilter=(r,e,t)=>{const a=cvt((0,lodash_1.omit)(r,e));return e=>{let n=0;if(Array.isArray(e))n=e.filter(a).length;return t(n,r)}},isFilterObject=r=>null!=r&&"object"==typeof r,cvt=r=>{if(r instanceof RegExp)return reTest(r);if(isFilterObject(r)&&isQuantifiedBy(r,"_atLeast"))return quantifiedFilter(r,"_atLeast",(r,e)=>r>=e._atLeast);if(isFilterObject(r)&&isQuantifiedBy(r,"_atMost"))return quantifiedFilter(r,"_atMost",(r,e)=>r<=e._atMost);if(isFilterObject(r)&&isQuantifiedBy(r,"_none"))return quantifiedFilter(r,"_none",(r,e)=>e._none?0===r:0!==r);if(isFilterObject(r)&&isQuantifiedBy(r,"_every"))return cvt({_not:{...(0,lodash_1.omit)(r,"_every")},_none:r&&r._every});if(r&&(0,runtime_1.isCompound)(r))return and(Object.keys(r).map(t=>{const a=r[t];if("_options"===t)return ptrue;if("_"===t[0]&&"_id"!==t&&"_sortValue"!==t){if(!e[t])throw new xtrem_shared_1.LogicError(`bad operator: ${t}`);return e[t](a,r)}return compose(cvt(a),walk(t))}));return e._eq(r)};return cvt}static fillData(r,e,t,a,n){const fill=async(a,n,i)=>{let o={...n};if(i&&"object"==typeof i)await(0,xtrem_async_helper_1.asyncArray)(Object.keys(i)).forEach(async s=>{const p=a.properties.find(r=>r.name===s),l=i[s];if(l){let a=o[s];if(p){if(p.isForeignNodeProperty()&&a&&"object"==typeof l){const{targetFactory:e}=p;if(a=await t(r,p,n),Array.isArray(a))o[s]=await(0,xtrem_async_helper_1.asyncArray)(a).map(r=>fill(e,r,l)).toArray();else if("object"==typeof a)o[s]=await fill(e,a,l)}}else if(Array.isArray(l))await(0,xtrem_async_helper_1.asyncArray)(l).forEach(async r=>{o=await fill(e,o,r)});else if("object"==typeof l)o=await fill(e,o,l)}});return o};return(0,xtrem_async_helper_1.asyncArray)(a).map(r=>fill(e,r,n)).toArray()}static async applyFilter(r,e,t,a,n,i){const o=RecordPaging.parseFilter(r,e,n),s=RecordPaging.converter(i)(o),p=(await this.fillData(r,e,t,a,o)).filter(r=>s(r)).map(r=>r._id);return a.filter(r=>p.includes(r._id))}static async applyOrderBy(r,e,t,a,n){const i=t.map((r,e)=>({...r,$$index:e})),o=await this.fillData(r,e,n,i,a);return(await(0,xtrem_async_helper_1.asyncArray)(o).sort(async(t,i)=>(await RecordPaging.compileOrderBy(r,e,a,n))(t,i)).toArray()).map(r=>t[r.$$index])}static applyPagingOperation(r,e,t,a,n,i,o){const s=n.map((r,e)=>{const t=[];for(let r=0;r<e;r+=1)t.push({[n[r].path.join(".")]:{_eq:i[r].value}});let a;if(r.direction>0)a="before"===o?"_lt":"_gt";else a="before"===o?"_gt":"_lt";return t.push({[n[e].path.join(".")]:{[a]:i[e].value}}),1===t.length?t[0]:{_and:t}}),p=1===s.length?s[0]:{_or:s};return RecordPaging.applyFilter(r,e,t,a,p)}static convertFilter(r,e,t,a=[],n){if(!t)return t;if(Array.isArray(t)){if(0===t.length)return[];const i=t.map((t,i)=>RecordPaging.convertFilter(r,e,t,[...a,String(i)],n)).filter(r=>void 0!==r);return 0===i.length?void 0:i}if(n?.isForeignNodeProperty()){if("string"==typeof t||"number"==typeof t)return{_id:t};if(t instanceof ts_api_1.Node)return{_id:t._id}}if(n?.isDateProperty()&&"string"==typeof t)return(0,runtime_1.dateFromString)(t);if((0,runtime_1.isCompound)(t))return Object.keys(t).reduce((i,o)=>{const s=t[o];if("_"===o[0]){const t=e.properties.find(r=>r.name===o&&r.isSystemProperty)||system_properties_1.SystemProperties.getSystemProperties(e).find(r=>r.name===o);return i[o]=RecordPaging.convertFilter(r,e,s,[...a,o],t||n),i}const p=e.findProperty(o);if(p.isReferenceProperty()&&s&&(0,runtime_1.isCompound)(s)||p.isCollectionProperty()||p.isReferenceArrayProperty()){const{targetFactory:e}=p;return i[o]=RecordPaging.convertFilter(r,e,s,[...a,o],p),i}return i[o]=RecordPaging.convertFilter(r,e,s,[...a,o],p),i},{});return t}static parseFilter(r,e,t){if(!t)return t;return RecordPaging.convertFilter(r,e,t)}static async applyPagingOptions(r,e,t,a,n){let i=t,o=i.length;if(!n)return Promise.resolve({items:i,totalCount:o});if(n.last){if(n.first)throw new Error("first cannot be supplied with last.");if(n.after)throw new Error("after cannot be supplied with last.")}else if(n.before)throw new Error("before cannot be supplied without last.");if(n.filter)i=await RecordPaging.applyFilter(e,r,a,i,n.filter,e.locales),o=i.length;let s=[];if("external"!==r.storage)s=r.parseOrderBy(e,n.orderBy);else s=r.externalStorageManager?r.externalStorageManager.parseOrderBy(e,n.orderBy).map(e=>{const t=r.findProperty(e.property.name);return{...e,property:t}}):[];if(0!==s.length&&n.orderBy)i=await RecordPaging.applyOrderBy(e,r,i,n.orderBy,a);const getCursorValue=e=>{if("external"===r.storage){if(!r.externalStorageManager)throw new Error(`${r.name}: External storage manager is not defined`);return r.externalStorageManager.parseCursor(s,e).map(e=>({property:r.findProperty(e.property.name),value:e.value}))}return(0,types_1.parseCursor)(s.map(r=>r.property),e)};if(null!=n.after)i=await RecordPaging.applyPagingOperation(e,r,a,i,s,getCursorValue(n.after),"after");if(null!=n.before)i=await RecordPaging.applyPagingOperation(e,r,a,i,s,getCursorValue(n.before),"before");if(null!=n.first&&0!==n.first)i=i.slice(0,n.first);if(null!=n.last&&0!==n.last)i=i.slice(-n.last);return{items:i,totalCount:o}}}exports.RecordPaging=RecordPaging;
//# sourceMappingURL=record-paging.js.map