import { AnyRecord, AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
import { Property } from '../properties';
import { Context, NodeFactory, PropertyAndValue } from '../runtime';
import { OrderByClause } from '../sql';
import { AnyFilterValue, NodeQueryOptions } from '../ts-api';
type Comparator = (val1: AnyValue, val2: AnyValue) => AsyncResponse<number>;
type GetPropertyValue = (context: Context, property: Property, parent: AnyRecord) => AsyncResponse<AnyValue>;
type Predicate = (val: AnyValue) => boolean;
export declare class RecordPaging {
    /**
     * Compose two comparators into a new comparator
     * @param f
     * @param g
     * @returns
     */
    static composeComparators(f: Comparator, g: Comparator): Comparator;
    /**
     * Compile the orderBy clause into a comparator
     * @param context
     * @param factory
     * @param orderBy
     * @param getPropertyValue
     * @returns
     */
    static compileOrderBy(context: Context, factory: NodeFactory, orderBy: AnyRecord, getPropertyValue: GetPropertyValue): Promise<Comparator>;
    /**
     * Convert a filter object into a predicate function that can be used to filter an array of objects.
     * The filter object can contain the following operators:
     * - _eq: equal
     * - _ne: not equal
     * - _gt: greater than
     * - _gte: greater than or equal
     * - _lt: less than
     * - _lte: less than or equal
     * - _in: in
     * - _nin: not in
     * - _and: and
     * - _or: or
     * - _nor: nor
     * - _not: not
     * - _mod: mod
     * - _regex: regex
     * And the follow quantifiers:
     * - _atLeast: at least
     * - _atMost: at most
     * - _none: none
     * - _every: every
     *
     * @param locales
     * @returns
     */
    static converter(locales?: string[]): (val: AnyValue) => Predicate;
    /**
     * We will receive the data object with the references, collections and referencesArrays filled with the _id
     * We will fill the data with the actual data from the data store, so that the Predicate can be applied.
     * We will only fill the data that is needed for the filter.
     * @param context
     * @param factory
     * @param getPropertyValue
     * @param items
     * @param filter
     * @returns
     */
    static fillData(context: Context, factory: NodeFactory, getPropertyValue: GetPropertyValue, items: AnyRecord[], obj: AnyFilterValue): Promise<AnyRecord[]>;
    /**
     * Apply the filter to a list of items
     * @param context
     * @param factory
     * @param getPropertyValue
     * @param items
     * @param filter
     * @param locales
     * @returns
     */
    static applyFilter(context: Context, factory: NodeFactory, getPropertyValue: GetPropertyValue, items: AnyRecord[], filter: AnyFilterValue, locales?: string[]): Promise<AnyRecord[]>;
    /**
     * Apply the orderBy clause to a list of items
     * @param context
     * @param factory
     * @param items
     * @param orderBy
     * @param getPropertyValue
     * @returns
     */
    static applyOrderBy(context: Context, factory: NodeFactory, items: AnyRecord[], orderBy: AnyRecord, getPropertyValue: GetPropertyValue): Promise<AnyRecord[]>;
    /**
     * Apply the paging operation (before, after) to a list of items
     * @param context
     * @param factory
     * @param getPropertyValue
     * @param items
     * @param orderByClauses
     * @param values
     * @param op
     * @returns
     */
    static applyPagingOperation(context: Context, factory: NodeFactory, getPropertyValue: GetPropertyValue, items: AnyRecord[], orderByClauses: OrderByClause[], values: PropertyAndValue[], op: 'after' | 'before'): Promise<AnyRecord[]>;
    /**
     * Convert the filter object into a format that can be used by the query
     * @param context
     * @param factory
     * @param filter
     * @param parentPath
     * @param property
     * @returns
     */
    static convertFilter(context: Context, factory: NodeFactory, filter: AnyFilterValue | undefined, parentPath?: string[], property?: Property): AnyFilterValue | any[] | undefined;
    /**
     * Parse the filter object
     * @param context
     * @param factory
     * @param filter
     * @returns
     */
    static parseFilter(context: Context, factory: NodeFactory, filter: AnyFilterValue | undefined): AnyFilterValue | undefined;
    /**
     * Apply the paging options to a list of records (filter, order by, first, last, after, before)
     * @param factory
     * @param context
     * @param records
     * @param getPropertyValue
     * @param options
     * @returns
     */
    static applyPagingOptions(factory: NodeFactory, context: Context, records: AnyRecord[], getPropertyValue: GetPropertyValue, options?: NodeQueryOptions): Promise<{
        items: AnyRecord[];
        totalCount: number;
    }>;
}
export {};
//# sourceMappingURL=record-paging.d.ts.map