/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.checkAndSyncValuesHash=checkAndSyncValuesHash,exports.checkAndSyncFactoryValuesHash=checkAndSyncFactoryValuesHash,exports.getTenantIdList=getTenantIdList;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),__1=require(".."),state_load_1=require("../node-state/state-load"),runtime_1=require("../runtime");async function checkAndSyncValuesHash(e,a,t){t?.info(`Checking and syncing values hash for tenant ${a}`),await e.withReadonlyContext(a,async a=>{await(0,xtrem_async_helper_1.asyncArray)(e.getAllFactories().filter(e=>e.isContentAddressable)).forEach(async e=>{if(!await e.table.tableExists(a))return;t?.info(`Checking and syncing values hash for factory ${e.name}`),await checkAndSyncFactoryValuesHash(a,e,t)})},{source:"customMutation"}),t?.info(`Finished checking and syncing values hash for tenant ${a}`)}async function checkAndSyncFactoryValuesHash(e,a,t){const n={onlyColumns:{_values_hash:true}},r={};await e.queryWithReader(a.nodeConstructor,{},async s=>{await s.forEach(async s=>{await state_load_1.StateLoad.resolveLazyLoadedValues(s.$.state);const o=a.getValuesHash(s.$.state.values);if(o===s.$.getRawPropertyValue("_valuesHash"))return;await e.runInWritableContext(async e=>{try{await a.table.update(e,{_id:s._id,_valuesHash:o},n)}catch(e){const a=(0,xtrem_shared_1.unwrapError)(e);if(a instanceof __1.DatabaseError&&"23505"===a.code)r[s._id]=o;else t?.error(`Error while updating _valuesHash for record ${s._id}`,e)}})})}),await(0,xtrem_async_helper_1.asyncArray)(Object.keys(r)).forEach(async s=>{t?.info(`Hash collision detected with hash ${r[s]}`),t?.info(`recordWithWrongHash ${s}`);const o=await e.tryRead(a.nodeConstructor,{_valuesHash:r[s]});if(!o)await e.runInWritableContext(async e=>{await a.table.update(e,{_id:s,_valuesHash:r[s]},n)}),t?.info(`recordWithRightHash not found, updated record ${s} with hash ${r[s]}`),delete r[s];else t?.info(`recordWithRightHash ${o._id}`),await(0,xtrem_async_helper_1.asyncArray)(a.application.getAllFactories()).forEach(async n=>{const r=n.properties.filter(e=>e.isReferenceProperty()&&!e.isInherited&&e.targetFactory.name===a.name).map(e=>e.name);if(0===r.length)return;t?.info(`factoryToFix ${JSON.stringify(n.name)}`),t?.info(`properties to update ${JSON.stringify(r)}`),await(0,xtrem_async_helper_1.asyncArray)(r).forEach(async a=>{const r=await e.bulkUpdate(n.nodeConstructor,{set:{[a]:o._id},where:{[a]:s}});t?.info(`updatedRecord ${r}`)})})}),await e.runInWritableContext(async e=>{await(0,xtrem_async_helper_1.asyncArray)(Object.keys(r)).forEach(t=>e.delete(a.nodeConstructor,{_id:t}))})}async function getTenantIdList(e){let a=[];return await e.asRoot.withReadonlyContext(null,async e=>{a=await runtime_1.Context.tenantManager.listTenantsIds(e)},{source:"customMutation"}),a}
//# sourceMappingURL=check-recompute-values-hash.js.map