import { Logger } from '@sage/xtrem-log';
import { Application } from '../application';
import { Context, NodeFactory } from '../runtime';
/**
 * Given a specific tenantId, this function will ensure that the _valuesHash of all content addressable nodes
 * in the tenant is correct. This is useful when importing/restoring anonymized data, where the _valuesHash is not updated.
 * @param application
 * @param tenantId
 * @param logger
 */
export declare function checkAndSyncValuesHash(application: Application, tenantId: string, logger: Logger): Promise<void>;
export declare function checkAndSyncFactoryValuesHash(context: Context, factory: NodeFactory, logger: Logger): Promise<void>;
export declare function getTenantIdList(application: Application): Promise<string[]>;
//# sourceMappingURL=check-recompute-values-hash.d.ts.map