/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.fastHash=exports.notNull=void 0,exports.typeDefaultValue=typeDefaultValue,exports.customFieldTypeDefaultValue=customFieldTypeDefaultValue,exports.safeParseInt=safeParseInt,exports.parseTypeValue=parseTypeValue,exports.parsePropertyValue=parsePropertyValue,exports.formatPropertyValue=formatPropertyValue,exports.getNameWithoutPackage=getNameWithoutPackage,exports.cursorChecksum=cursorChecksum,exports.removeCursorChecksum=removeCursorChecksum,exports.parseCursorValues=parseCursorValues,exports.parseCursor=parseCursor;const xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_shared_1=require("@sage/xtrem-shared"),crc32=require("crc-32"),runtime_1=require("../runtime"),arrays_1=require("./arrays"),binary_stream_1=require("./binary-stream"),text_stream_1=require("./text-stream"),uuid_1=require("./uuid"),notNull=e=>e;function typeDefaultValue(e,r=false,t=false,a){if(r)return null;switch(e){case"string":return"sql"===a&&t?{}:"";case"float":case"double":case"integer":case"short":return 0;case"integerRange":return new xtrem_date_time_1.IntegerRange(null,null);case"integerArray":case"enumArray":case"referenceArray":case"stringArray":return[];case"decimalRange":return new xtrem_date_time_1.DecimalRange(null,null);case"decimal":return xtrem_decimal_1.Decimal.make(0);case"enum":return 1;case"boolean":return false;case"date":return xtrem_date_time_1.date.today();case"dateRange":return new xtrem_date_time_1.DateRange(null,null);case"datetimeRange":return new xtrem_date_time_1.DatetimeRange(null,null);case"time":return xtrem_date_time_1.time.now("UTC");case"datetime":return xtrem_date_time_1.Datetime.now();case"reference":return null;case"uuid":return uuid_1.Uuid.generate();case"binaryStream":return binary_stream_1.BinaryStream.fromBuffer(Buffer.alloc(0));case"textStream":return text_stream_1.TextStream.empty;case"json":return{};default:throw new xtrem_shared_1.LogicError(`unsupported type ${e}`)}}function customFieldTypeDefaultValue(e,r=false){switch(e){case"string":return"";case"float":case"double":case"integer":case"short":return 0;case"integerRange":return new xtrem_date_time_1.IntegerRange(null,null);case"integerArray":case"enumArray":case"referenceArray":case"stringArray":return[];case"decimalRange":return new xtrem_date_time_1.DecimalRange(null,null);case"decimal":return xtrem_decimal_1.Decimal.make(0);case"enum":return r?1:null;case"boolean":return false;case"date":return r?xtrem_date_time_1.date.today():null;case"dateRange":return new xtrem_date_time_1.DateRange(null,null);case"datetimeRange":return new xtrem_date_time_1.DatetimeRange(null,null);case"time":return r?xtrem_date_time_1.time.now("UTC"):null;case"datetime":return r?xtrem_date_time_1.Datetime.now():null;case"reference":return null;case"uuid":return r?uuid_1.Uuid.generate():null;case"binaryStream":return binary_stream_1.BinaryStream.fromBuffer(Buffer.alloc(0));case"textStream":return text_stream_1.TextStream.empty;case"json":return{};default:throw new xtrem_shared_1.LogicError(`unsupported type ${e}`)}}function getTypeError(e,r){if(r)return new xtrem_shared_1.LogicError(`column ${r}: ${e}`);return new Error(e)}function safeParseInt(e,r){const t=Number(e);if(!Number.isInteger(t))throw getTypeError(`invalid integer value ${e}`,r);return t}function safeParseFloat(e,r){const t=Number(e);if(!Number.isFinite(t))throw getTypeError(`invalid number value ${e}`,r);return t}function safeParseBoolean(e,r){if("boolean"==typeof e)return e;if("false"===e)return false;if("true"===e)return true;throw getTypeError(`invalid boolean value ${e}`,r)}function assertString(e){if("string"!=typeof e)throw getTypeError(`value is not a string: ${e} of type ${typeof e}`)}function parseTypeValue(e,r,t){if("string"===e||"json"===e)return r;if(null==r||""===r)return null;switch(e){case"float":case"double":case"decimal":return safeParseFloat(r,t);case"integerRange":return assertString(r),xtrem_date_time_1.IntegerRange.parse(r);case"integerArray":case"referenceArray":assertString(r);return(0,arrays_1.stringToArray)(r).map(e=>Number(e));case"enumArray":case"stringArray":return assertString(r),(0,arrays_1.stringToArray)(r);case"decimalRange":return assertString(r),xtrem_date_time_1.DecimalRange.parse(r);case"integer":case"short":return safeParseInt(r,t);case"boolean":return safeParseBoolean(r,t);case"enum":return r;case"date":return assertString(r),xtrem_date_time_1.DateValue.parse(r);case"dateRange":return assertString(r),xtrem_date_time_1.DateRange.parse(r);case"datetimeRange":return assertString(r),xtrem_date_time_1.DatetimeRange.parse(r);case"time":return assertString(r),xtrem_date_time_1.Time.parse(r);case"datetime":return assertString(r),xtrem_date_time_1.Datetime.parse(r);case"uuid":return assertString(r),uuid_1.Uuid.fromString(r);default:throw getTypeError(`unsupported type ${r}`,t)}}function parsePropertyValue(e,r){let t=e.isReferenceProperty()?e.columnType:e.type;if(!t&&e.isReferenceProperty()&&"external"===e.factory.storage&&"sql"===e.targetFactory.storage)t="string"==typeof r?"string":"integer";return parseTypeValue(t,r,e.name)}function formatPropertyValue(e,r){return r?r.toString():""}exports.notNull=notNull;const fastHash=e=>crc32.str(e)>>>0;function getNameWithoutPackage(e){return e.replace(/^([^/]*\/)*/,"")}function cursorChecksum(e){const r=e.replace(/'/g,'"');return`#${((0,exports.fastHash)(r.replace(/'/g,'"'))%100).toString().padStart(2,"0")}`}function removeCursorChecksum(e){if(!e)return e;const r=e.substring(0,e.length-3),t=cursorChecksum(r);if(!e.endsWith(t))throw new xtrem_shared_1.SystemError(`${e}: invalid cursor value (checksum verification failed)`);return r}function parseCursorValues(e,r){if(0===e.length)throw new xtrem_shared_1.SystemError("Cannot parse cursor: missing orderBy");if(r.length>e.length)throw new xtrem_shared_1.SystemError("Cannot parse cursor: too many values");if(r.length<e.length)throw new xtrem_shared_1.SystemError("Cannot parse cursor: too few values");return e.map((e,t)=>({property:e,value:parsePropertyValue(e,r[t])}))}function parseCursor(e,r){const t=removeCursorChecksum(r);return parseCursorValues(e,(0,runtime_1.friendlyJsonParse)(t))}exports.fastHash=fastHash;
//# sourceMappingURL=util.js.map