/** @ignore */ /** */
import { AnyValue } from '@sage/xtrem-shared';
import { NodeStorage, TypeName } from '../decorators';
import { Property } from '../properties';
import { PropertyAndValue } from '../runtime';
/**
 * `notNull(x)` is equivalent to `x!` but keeps sonar quiet
 *
 * We use it to deal with nullable properties inside functions that must be convertible to SQL
 * because the ts-to-sql converter does not (yet) support local variables inside functions.
 */
export declare const notNull: <T extends AnyValue>(x: T) => NonNullable<T>;
export declare function typeDefaultValue(type: TypeName | undefined, isNullable?: boolean, isLocalized?: boolean, storage?: NodeStorage): any;
/**
 * Returns the default value for a custom field, based on its type and isMandatory attribute.
 * We cannot use getTypeDefaultValue() for this because custom fields do not have an isNullable attribute.
 * This function only returns `null` if the field is not mandatory and the type does not have an _obvious_ default value.
 * 0 is an obvious default value for numbers but null is a more obvious default value than date.today() for non mandatory dates.
 */
export declare function customFieldTypeDefaultValue(type: TypeName | undefined, isMandatory?: boolean): any;
export declare function safeParseInt(value: unknown, propertyName?: string): number;
/**
 * Parses a value according to the specified type, converting it to the appropriate JavaScript type or structure.
 *
 * @param type - The type to parse the value as. Supported types include:
 *   - 'string', 'json', 'float', 'double', 'integerRange', 'integerArray', 'referenceArray',
 *     'enumArray', 'stringArray', 'decimalRange', 'integer', 'short', 'decimal', 'boolean',
 *     'enum', 'date', 'dateRange', 'datetimeRange', 'time', 'datetime', 'uuid'.
 * @param value - The value to be parsed. Can be of any type.
 * @param propertyName - (Optional) The name of the property being parsed, used for error reporting.
 * @returns The parsed value, converted to the appropriate type, or `null` if the value is `null` or an empty string.
 * @throws Will throw an error if the type is unsupported or if parsing fails for the given type.
 */
export declare function parseTypeValue(type: string | undefined, value: unknown, propertyName?: string): any;
/**
 * Fast non crypto hash to use only for non security purposes
 */
export declare const fastHash: (str: string) => number;
export declare function getNameWithoutPackage(fullName: string): string;
/** @disabled_internal */
export declare function parseCursor(orderByProperties: Property[], value: string): PropertyAndValue[];
//# sourceMappingURL=util.d.ts.map