/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StringArrayDataType=exports.StringDataType=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),data_type_1=require("./data-type");class StringDataType extends data_type_1.DataType{constructor(t){super("string",t)}get maxLength(){return this.options.maxLength??1/0}get isLocalized(){return this.options.isLocalized??false}async controlValue(t,e,a){if(await super.controlValue(t,e,a),this.maxLength&&a&&a.length>this.maxLength)e.addDiagnose(xtrem_shared_1.ValidationSeverity.error,`${a} exceeds the maximum length allowed for this field: ${this.maxLength} characters.`)}adaptValue(t,e){let a=e;if(!this.options.doNotTrim)a=a?.trim();if(this.options.truncate&&a&&a?.length>this.maxLength)return`${a?.substring(0,this.maxLength-3)}...`;return a}defaultValue(t){return this.options.defaultValue?this.options.defaultValue.call(t):super.defaultValue(t)}getMetaData(t){return{...super.getMetaData(t),type:"string",isDefault:false,maxLength:this.maxLength===1/0?null:this.maxLength,isLocalized:this.isLocalized,doNotTrim:!!this.dataTypeOptions().doNotTrim,truncate:!!this.dataTypeOptions().truncate}}}exports.StringDataType=StringDataType;class StringArrayDataType extends data_type_1.DataType{constructor(t){super("stringArray",t)}get maxLength(){return this.options.maxLength??1/0}async controlValue(t,e,a){await super.controlValue(t,e,a),a.forEach(t=>{if(this.maxLength&&t&&t.length>this.maxLength)e.addDiagnose(xtrem_shared_1.ValidationSeverity.error,`${t} exceeds the maximum length allowed for this field: ${this.maxLength} characters.`)})}getMetaData(t){const e=super.getMetaData(t);return{name:e.name,title:e.title,type:"stringArray",isDefault:false,maxLength:this.maxLength,isLocalized:!!this.dataTypeOptions().isLocalized,doNotTrim:!!this.dataTypeOptions().doNotTrim,truncate:!!this.dataTypeOptions().truncate}}}exports.StringArrayDataType=StringArrayDataType;
//# sourceMappingURL=string-data-type.js.map