import { AsyncResponse, integer, type Dict } from '@sage/xtrem-shared';
import { ValidationContext } from '../ts-api';
import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from './data-type';
export interface StringDataTypeOptions<T = unknown, ValT extends string | null = string> extends DataTypeOptions {
    maxLength?: number;
    isLocalized?: true;
    doNotTrim?: boolean;
    truncate?: boolean;
    defaultValue?: (this: T) => AsyncResponse<ValT | undefined>;
}
export interface StringDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
    maxLength: number | null;
    isLocalized: boolean;
    doNotTrim: boolean;
    truncate: boolean;
}
export interface StringArrayDataTypeMetadata<TitleT> extends StringDataTypeMetadata<TitleT> {
}
export declare class StringDataType<T = unknown, ValT extends string | null = string> extends DataType<ValT, T, StringDataTypeOptions<T, ValT>> {
    constructor(options: StringDataTypeOptions<T, ValT>);
    get maxLength(): integer;
    get isLocalized(): boolean;
    controlValue(node: T, cx: ValidationContext, val: string): Promise<void>;
    adaptValue(_node: T, val: ValT): AsyncResponse<ValT>;
    defaultValue(node: T): AsyncResponse<ValT | undefined>;
    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): StringDataTypeMetadata<TitleT>;
}
export declare class StringArrayDataType<T = unknown, ValT extends string[] | null = string[]> extends DataType<ValT, T, StringDataTypeOptions> {
    constructor(options: StringDataTypeOptions);
    get maxLength(): integer;
    controlValue(node: T, cx: ValidationContext, val: string[]): Promise<void>;
    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): StringArrayDataTypeMetadata<TitleT>;
}
//# sourceMappingURL=string-data-type.d.ts.map