/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TextStreamDataType=exports.BinaryStreamDataType=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),data_type_1=require("./data-type"),mime_type_helper_1=require("./mime-type-helper");function shrinkString(e,t){const a=t||500;return e.length>a?`${e.substr(0,a/2)}...${e.substr(-(a/2+a%2-3))}`:e}class StreamDataType extends data_type_1.DataType{constructor(e,t,a){super(e,t),this.unit=a}get maxLength(){return this.options.maxLength??1/0}get allowedContentTypes(){return this.options.allowedContentTypes||[]}get dangerouslyUnsafe(){return!!this.options.dangerouslyUnsafe}async controlValue(e,t,a){await super.controlValue(e,t,a);const r=t.path.join("."),n=xtrem_config_1.ConfigManager.getSizeLimit("maxStreamSize");if(this.getByteLength(a)>n)return void t.addDiagnose(xtrem_shared_1.ValidationSeverity.error,`Value of '${r}' exceeds the maximum length allowed: got ${a.value.length} expected ${n} ${this.unit}s max.`);if(!this.checkLength(a))return void t.addDiagnose(xtrem_shared_1.ValidationSeverity.error,`Value of '${r}' exceeds the maximum length allowed: got ${a.value.length} expected ${this.maxLength} ${this.unit}s max.`);await this.validateContent(e,r,a)}}class BinaryStreamDataType extends StreamDataType{constructor(e){super("binaryStream",e,"byte")}getByteLength(e){const t=e?.value;if(!t)return 0;return t.byteLength}checkLength(e){const t=e?.value;if(!t)return true;const a=this.getByteLength(e);return!(this.maxLength&&a>this.maxLength)}async validateContent(e,t,a){if(!e.$.factory.isPlatformNode&&a)await this.validateContentType(t,a)}async validateContentType(e,t){const a=t.value,r=await mime_type_helper_1.MimeTypeHelper.guessFromBuffer(a),n=xtrem_config_1.ConfigManager.current.binaryStreamContentTypes||[];if(!mime_type_helper_1.MimeTypeHelper.matchPatterns(n,r))throw new xtrem_shared_1.SystemError(`binary stream property '${e}' has a content type '${r}' not authorized by config. Expecting [${n}]`);if(!mime_type_helper_1.MimeTypeHelper.matchPatterns(this.allowedContentTypes,r))throw new xtrem_shared_1.SystemError(`binary stream property '${e}' has a content type '${r}' not authorized by property dataType. Expecting [${this.allowedContentTypes.map(e=>`'${e}'`)}]`)}getMetaData(e){return{...super.getMetaData(e),type:"binaryStream",isDefault:false,maxLength:this.maxLength===1/0?null:this.maxLength,allowedContentTypes:this.allowedContentTypes}}}exports.BinaryStreamDataType=BinaryStreamDataType;class TextStreamDataType extends StreamDataType{constructor(e){super("textStream",e,"character")}static{this.default=new TextStreamDataType({maxLength:2048,allowedContentTypes:["application/json","text/plain"]})}getByteLength(e){const t=e?.value;if(!t)return 0;return Buffer.byteLength(t)}checkLength(e){const t=e.value;if(!t)return true;const a=t.length;return!(this.maxLength&&a>this.maxLength)}async validateContent(e,t,a){if(!e.$.factory.isPlatformNode)await this.validateContentType(t,a);if(mime_type_helper_1.MimeTypeHelper.matchPatterns(await mime_type_helper_1.MimeTypeHelper.guessFromString(a.value),"*/xml"))TextStreamDataType.validateXmlAgainstXXE(a.value)}async validateContentType(e,t){const a=t,r=await a.contentType,n=xtrem_config_1.ConfigManager.current.textStreamContentTypes||[];if(!mime_type_helper_1.MimeTypeHelper.matchPatterns(n,r))throw new xtrem_shared_1.SystemError(`text stream property '${e}' value '${shrinkString(t.toString())}' has a content type '${r}' not authorized by config. Expecting [${n}]`);if(!mime_type_helper_1.MimeTypeHelper.matchPatterns(this.allowedContentTypes,r))throw new xtrem_shared_1.SystemError(`text stream property '${e}' value '${shrinkString(t.toString())}' has a content type '${r}' not authorized by property dataType. Expecting [${this.allowedContentTypes.map(e=>`'${e}'`)}]`)}static validateXmlAgainstXXE(e){const t=/<!ENTITY\s+(?:%\s+)?[^><\s]+\s+SYSTEM/;if(/<!DOCTYPE\s+/i.test(e)||t.test(e))throw new Error("DTD not allowed in xml")}async adaptValue(e,t){if(this.dangerouslyUnsafe)return await t.contentType,t;return await t.sanitized()}getMetaData(e){return{...super.getMetaData(e),type:"textStream",isDefault:false,maxLength:this.maxLength===1/0?null:this.maxLength,allowedContentTypes:this.allowedContentTypes}}}exports.TextStreamDataType=TextStreamDataType;
//# sourceMappingURL=stream-data-type.js.map