import { ColumnTypeName, Dict } from '@sage/xtrem-shared';
import { Application } from '../application';
import { Context } from '../runtime';
import { ValidationContext } from '../ts-api';
import { BinaryStream } from './binary-stream';
import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from './data-type';
import { Stream } from './stream';
import { TextStream } from './text-stream';
export interface StreamDataTypeOptions extends DataTypeOptions {
    maxLength?: number;
    allowedContentTypes?: string[];
    dangerouslyUnsafe?: boolean;
}
export interface StreamDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
    maxLength: number | null;
    allowedContentTypes: string[];
}
declare abstract class StreamDataType<ValT extends Stream | null, T = unknown> extends DataType<ValT, T, StreamDataTypeOptions> {
    private readonly unit;
    constructor(type: ColumnTypeName, options: StreamDataTypeOptions, unit: string);
    get maxLength(): number;
    get allowedContentTypes(): string[];
    get dangerouslyUnsafe(): boolean;
    abstract checkLength(val: ValT): boolean;
    abstract getByteLength(val: ValT): number;
    abstract validateContent(node: T, name: string, val: ValT): Promise<void>;
    controlValue(node: T, cx: ValidationContext, val: ValT): Promise<void>;
}
export declare class BinaryStreamDataType<ValT extends BinaryStream | null = BinaryStream, T = unknown> extends StreamDataType<ValT, T> {
    constructor(options: StreamDataTypeOptions);
    getByteLength(val: BinaryStream | null): number;
    checkLength(val: BinaryStream | null): boolean;
    validateContent(node: T, name: string, val: BinaryStream | null): Promise<void>;
    validateContentType(name: string, val: BinaryStream): Promise<void>;
    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, Application, Context>): StreamDataTypeMetadata<TitleT>;
}
export declare class TextStreamDataType<ValT extends TextStream = TextStream, T = unknown> extends StreamDataType<ValT, T> {
    constructor(options: StreamDataTypeOptions);
    static default: TextStreamDataType<TextStream, unknown>;
    getByteLength(val: TextStream | null): number;
    checkLength(val: TextStream): boolean;
    validateContent(node: T, name: string, val: TextStream): Promise<void>;
    validateContentType(name: string, val: TextStream): Promise<void>;
    static validateXmlAgainstXXE(value: string): void;
    adaptValue(node: T, val: ValT): Promise<ValT>;
    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, Application, Context>): StreamDataTypeMetadata<TitleT>;
}
export {};
//# sourceMappingURL=stream-data-type.d.ts.map