/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ReferenceDataType=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),lodash_1=require("lodash"),runtime_1=require("../runtime"),data_type_1=require("./data-type");class ReferenceDataType extends data_type_1.DataType{constructor(e){super("reference",e)}get isNullable(){return!!this.options.isNullable}get ignoreIsActive(){return!!this.options.ignoreIsActive}get isDefault(){return!!this.options.isDefault}get referenceNodePackage(){return this.options.referenceNodePackage}get node(){return`${this.referenceNodePackage}/${this.options.reference().name}`}getMetaData(e){const t=e.application?.getFactoryByConstructor(this.options.reference());if(!t)throw new xtrem_shared_1.LogicError("Factory not found for reference data type");const{valuePath:a,helperTextPath:n,columnPaths:r,tunnelPageIdPath:i,tunnelPage:o,imageFieldPath:s}=this.dataTypeOptions().lookup,getBinding=(t,a)=>{const n=a.isEnumProperty()||a.isEnumArrayProperty()?a.dataType.enumFullName():null;return{bind:t,title:a&&e.localize(a.getLocalizedTitleKey(),a.name),type:a.type,enumType:n}},getPropertyFromPath=(e,t,a=t.split("."))=>{const[n,...r]=a,i=e.findProperty(n);if(1===a.length||i.isTextStreamProperty()||i.isBinaryStreamProperty()){if(i.isForeignNodeProperty())throw new xtrem_shared_1.LogicError(`Bind path on dataType cannot end on a reference or collection: ${this.name} - ${t}`);return getBinding(t,i)}if(!i.isReferenceProperty())throw i.logicError(`Invalid property in dataType: ${this.name}`);return getPropertyFromPath(i.targetFactory,t,r)},c=getPropertyFromPath(t,a),p=n?getPropertyFromPath(t,n):void 0,l=s?getPropertyFromPath(t,s):void 0,f=i?getPropertyFromPath(t,i):void 0,d=r.map(e=>getPropertyFromPath(t,e));if(!this.name)throw new xtrem_shared_1.LogicError("name is missing");let u;try{u=e.localize(this.getLocalizedTitleKey(),this.name)}catch{u=e.localize(t.getLocalizedTitleKey(),this.name)}return{name:this.name,title:u,type:"reference",isDefault:!!this.options.isDefault,node:`${this.pack}/${t.name}`,value:c,helperText:p,imageField:l,columns:d,tunnelPage:o,tunnelPageId:f}}static getNodeDefaultDataType(e,t){const a=Object.values(e.dataTypes).filter(e=>e instanceof ReferenceDataType&&e.options.reference().name===t.name);return a.find(e=>e instanceof ReferenceDataType&&e.isDefault)??a.find(e=>e instanceof ReferenceDataType&&e.name===(0,lodash_1.camelCase)(t.name))??a[0]}checkReferenceDataTypeUniqueness(e,t){if(this.isDefault&&e.package.isService)throw new Error(`isDefault Reference datatype cannot be defined in a service package. ${this.name} in ${t.name}`);if(this.options.isDefault){const e=Object.values(t.application.dataTypes).find(e=>e.name!==this.name&&e instanceof ReferenceDataType&&e.options.isDefault&&e.options.reference().name===this.options.reference().name);if(e)throw new Error(`Default dataType ${this.name} for ${this.options.reference().name} node in ${t.name} already declared as default in ${e.pack} -> ${e.name}`)}}getDataTypeReferenceNodePackage(e,t){if(e.extensions?.find(e=>runtime_1.NodeFactory.getExtensionPackage(e).name===t.name))return t.name;return e.package.name}setReferenceNodePackage(e){const t=e.application.getFactoryByName(this.options.reference().name);this.checkReferenceDataTypeUniqueness(t,e),this.options.referenceNodePackage=this.getDataTypeReferenceNodePackage(t,e)}}exports.ReferenceDataType=ReferenceDataType;
//# sourceMappingURL=reference-data-type.js.map