/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MimeTypeHelper=void 0;const file_type_1=require("file-type"),matcher=require("matcher"),mimeTypes=require("mime-types"),sass=require("sass"),xmlTagRegex=/<\/?[a-z][^><]*?>/,xmlDtdRegex=/<!(doctype|entity|element) /i,htmlHeaderRegex=/^(?:<!--[^><]*?-->[\s\n\r]*)*<(!DOCTYPE html|html|head|body)\b/i,cssRegex=/[^{;}\s][^{;}]*(\{[^{}]*\})?/g;class MimeTypeHelper{static async getMimeType(e){const t=await(0,file_type_1.fileTypeFromBuffer)(e);return t?.mime}static isValidMimeType(e){return"application/graphql"===e||false!==mimeTypes.extension(e)}static isLikelyJsonBuffer(e){const t=e.subarray(0,1).toString("utf8"),r=e.subarray(-1).toString("utf8");if("{"===t&&"}"===r)return true;return false}static countFields(e,t){return e.replace(/"[^"]*"/g,"").split(t).length}static isLikelyCsvBuffer(e){const t=e.split(/\r?\n/).filter(Boolean),r=MimeTypeHelper.countFields(t[0],",");return!!(t[1]&&MimeTypeHelper.countFields(t[1],",")===r)}static async guessFromString(e,t){if(!e)return"text/plain";try{return JSON.parse(e),"application/json"}catch{}const r=await MimeTypeHelper.getMimeType(Buffer.from(e));if(!r||"text/plain"===r){if(htmlHeaderRegex.test(e))return"text/html";if(xmlDtdRegex.test(e))return"application/xml";if(xmlTagRegex.test(e)){if(t&&["text/xml","application/xml"].includes(t))return"application/xml";if("text/csv"===t)return"text/csv";if((!t||"text/css"===t)&&cssRegex.test(e))try{return sass.compileString(e),"text/css"}catch{}return"text/html"}}return r||"text/plain"}static async guessFromBuffer(e){const t=await MimeTypeHelper.getMimeType(e);if(t)return t;const r=e.subarray(0,1e3).toString("utf8");if(r.includes("<svg "))return"image/svg+xml";if(MimeTypeHelper.isLikelyJsonBuffer(e))return"application/json";if(MimeTypeHelper.isLikelyCsvBuffer(r))return"application/csv";return"application/octet-stream"}static isValid(e,t){if(!t)return true;return t.some(t=>!!e.match(t))}static matchPatterns(e,t){return matcher(e,t).length>0}}exports.MimeTypeHelper=MimeTypeHelper;
//# sourceMappingURL=mime-type-helper.js.map