/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.DecimalDataType=exports.RoundingMode=void 0;const xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash"),data_type_1=require("./data-type");var RoundingMode;!function(e){e[e.roundUp=0]="roundUp",e[e.roundDown=1]="roundDown",e[e.roundCeil=2]="roundCeil",e[e.roundFloor=3]="roundFloor",e[e.roundHalfUp=4]="roundHalfUp",e[e.roundHalfDown=5]="roundHalfDown",e[e.roundHalfEven=6]="roundHalfEven",e[e.roundHalfCeil=7]="roundHalfCeil",e[e.roundHalfFloor=8]="roundHalfFloor"}(RoundingMode||(exports.RoundingMode=RoundingMode={}));class DecimalDataType extends data_type_1.DataType{static{this.defaultRoundingMode=RoundingMode.roundHalfUp}static{this.defaultPrecision=16}static{this.defaultScale=2}constructor(e){super("decimal",e),this.options=e}get roundingMode(){return this.options.roundingMode??DecimalDataType.defaultRoundingMode}get precision(){return this.options.precision??DecimalDataType.defaultPrecision}get scale(){return this.options.scale??(void 0===this.options.precision?DecimalDataType.defaultScale:0)}static toImplementation(e){return e instanceof xtrem_decimal_1.Decimal?e:new xtrem_decimal_1.Decimal(e)}static fromImplementation(e){return e}adaptValue(e,t){if(null==t)return t;const a=DecimalDataType.toImplementation(t).toDecimalPlaces(this.scale,this.roundingMode);return DecimalDataType.fromImplementation(a)}async controlValue(e,t,a){await super.controlValue(e,t,a);const i=a&&DecimalDataType.toImplementation(a);if(this.precision&&i&&i.precision()>this.precision)t.addDiagnose(xtrem_shared_1.ValidationSeverity.error,`${a} exceeds the maximum precision allowed for this field: ${this.precision}.`);if(this.scale&&i&&i.decimalPlaces()>this.scale)t.addDiagnose(xtrem_shared_1.ValidationSeverity.error,`${a} exceeds the maximum scale allowed for this field: ${this.scale}.`)}static toDecimalPlaces(e,t,a=DecimalDataType.defaultRoundingMode){const i=this.toImplementation(e).toDecimalPlaces(t,a);return this.fromImplementation(i)}getMetaData(e){return{...super.getMetaData(e),type:"decimal",isDefault:false,precision:this.precision,scale:this.scale,roundingMode:_.invert(_.pickBy(RoundingMode,_.isNumber))[this.roundingMode]}}}exports.DecimalDataType=DecimalDataType;
//# sourceMappingURL=decimal-data-type.js.map