import { integer } from '@sage/xtrem-client';
import { AsyncResponse, type Dict } from '@sage/xtrem-shared';
import { decimal } from '../ts-api';
import { ValidationContext } from '../ts-api/validation';
import { DataType, DataTypeMetadata, DataTypeOptions, MetaDataOptions } from './data-type';
export declare enum RoundingMode {
    roundUp = 0,
    roundDown = 1,
    roundCeil = 2,
    roundFloor = 3,
    roundHalfUp = 4,
    roundHalfDown = 5,
    roundHalfEven = 6,
    roundHalfCeil = 7,
    roundHalfFloor = 8
}
export interface DecimalDataTypeOptions extends DataTypeOptions {
    precision?: number;
    scale?: number;
    roundingMode?: RoundingMode;
}
export interface DecimalDataTypeMetadata<TitleT> extends DataTypeMetadata<TitleT> {
    precision: number;
    scale: number;
    roundingMode: keyof RoundingMode;
}
export declare class DecimalDataType<T = unknown, ValT extends decimal | null = decimal> extends DataType<ValT, T, DecimalDataTypeOptions> {
    protected options: DecimalDataTypeOptions;
    static defaultRoundingMode: RoundingMode;
    static defaultPrecision: number;
    static defaultScale: number;
    constructor(options: DecimalDataTypeOptions);
    /** default is roundHalfUp */
    get roundingMode(): RoundingMode;
    /** default is 16 */
    get precision(): integer;
    /** default is 2
     * if we have a precision but no scale, assume that scale is 0
     */
    get scale(): integer;
    private static toImplementation;
    private static fromImplementation;
    adaptValue(_node: T, val: ValT): AsyncResponse<ValT>;
    controlValue(node: T, cx: ValidationContext, val?: decimal): Promise<void>;
    static toDecimalPlaces(val: number, scale: number, roundingMode?: RoundingMode): decimal;
    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): DecimalDataTypeMetadata<TitleT>;
}
//# sourceMappingURL=decimal-data-type.d.ts.map