import { AnyValue, AsyncResponse, ColumnTypeName, type Dict } from '@sage/xtrem-shared';
import { ServiceOption } from '../application';
import { ValidationContext } from '../ts-api/validation';
export interface DataTypeOptions {
    serviceOptions?: () => ServiceOption[];
}
export type DataTypeLocalize<TitleT> = (localizationKey: string, name: string) => TitleT;
export interface FieldBinding<TitleT> {
    bind: string;
    title?: TitleT;
    type?: string;
    enumType?: string | null;
}
export interface DataTypeMetadata<TitleT> {
    name: string;
    title: TitleT;
    type: string;
    isDefault: boolean;
}
export interface MetaDataOptions<TitleT, ApplicationT extends any, ContextT extends any> {
    localize: DataTypeLocalize<TitleT>;
    application: ApplicationT;
    context?: ContextT;
}
export declare abstract class DataType<ValT extends AnyValue, T, OptionsT extends DataTypeOptions = DataTypeOptions> {
    readonly type: ColumnTypeName;
    protected readonly options: OptionsT;
    name?: string;
    pack?: string;
    constructor(type: ColumnTypeName, options: OptionsT);
    get serviceOptions(): ServiceOption[];
    defaultValue<FullT extends T>(_node: FullT): AsyncResponse<ValT | undefined>;
    controlValue<FullT extends T>(_node: FullT, _cx: ValidationContext, _val: any): AsyncResponse<void>;
    adaptValue<FullT extends T>(_node: FullT, _val: ValT): AsyncResponse<ValT>;
    dataTypeOptions(): OptionsT;
    getLocalizedTitleKey(): string;
    getMetaData<TitleT extends string | Dict<string>>(options: MetaDataOptions<TitleT, any, any>): DataTypeMetadata<TitleT>;
}
export declare const isInt32: (val: any) => boolean;
//# sourceMappingURL=data-type.d.ts.map