/** @packageDocumentation @module runtime */
import { AnyRecord, AnyValue } from '@sage/xtrem-async-helper';
import { Decimal } from '@sage/xtrem-decimal';
import { Dict, integer } from '@sage/xtrem-shared';
import { datetime } from '.';
import { InternalAttachmentAssociationData } from '../application/attachment-manager';
import { InternalNoteAssociationData } from '../application/note-manager';
import { Decorated } from '../decorators';
import { SyncInfo } from '../synchronization/sync-info';
import { Collection } from './collection';
import { Node$ } from './node-$';
/**
 * The root `Node` class
 *
 * All  node classes will derive from this class.
 */
export declare class Node extends Decorated {
    #private;
    /**
     * Reference to an object that carries system methods and properties related to the node.
     *
     * For example, you can retrieve the node's status with `node.$.status`, or its context with
     * `node.$.context`.
     * You also use this special reference to save a modified node to the database with `node.$.save()`.
     */
    get $(): Node$<this>;
    /**
     * The internal id of the node.
     * This id is unique within the node's factory.
     * Node : id are negative for newly created nodes that were not saved yet.
     */
    get _id(): number;
    /**
     * The node's source ID, an ID that relates the record to the source system.
     */
    get _sourceId(): Promise<string>;
    /**
     * The node's sort value, only valid on collection child nodes.
     */
    get _sortValue(): Promise<integer>;
    /**
     * The node's sort value, only valid on collection child nodes.
     */
    get _vendor(): Promise<Node | null>;
    /**
     * The node's etag value.
     */
    get _etag(): Promise<string>;
    /**
     * The node's creation timestamp.
     */
    get _createStamp(): Promise<datetime>;
    /**
     * The node's update timestamp
     */
    get _updateStamp(): Promise<datetime>;
    /**
     * The node's synchronization tick
     */
    get _syncTick(): Promise<Decimal>;
    /**
     * The node's synchronization tick
     */
    get _syncInfo(): Promise<SyncInfo>;
    /**
     * The node's custom data value.
     */
    get _customData(): Promise<object>;
    /**
     * The node's values hash, only valid on content addressable nodes.
     */
    get _valuesHash(): Promise<string>;
    /**
     * attachments collection.
     */
    get _attachments(): Collection<InternalAttachmentAssociationData & Node>;
    /**
     * notes collection.
     */
    get _notes(): Collection<InternalNoteAssociationData & Node>;
    protected toJSON(): AnyRecord;
}
export type AnyNode = Node & Dict<Promise<AnyValue>>;
export type NodeFromInterface<I extends AnyRecord> = Node & {
    [K in keyof I]: I[K] extends Array<infer EltT> ? EltT extends AnyRecord ? Collection<NodeFromInterface<EltT>> : Promise<I[K]> : Promise<I[K] extends AnyRecord ? NodeFromInterface<I[K]> : I[K]>;
};
//# sourceMappingURL=node.d.ts.map