/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Activity=exports.InternalPermissionGrant=exports.InternalOperationGrant=exports.InternalBaseGrant=void 0;const _=require("lodash"),fsp=require("path"),activity_manager_1=require("../application/activity-manager"),system_properties_1=require("../runtime/system-properties");class InternalBaseGrant{constructor(e){this.type=e}get key(){return""}isOperationGrant(){return"operationGrant"===this.type}isPermissionGrant(){return"permissionGrant"===this.type}}exports.InternalBaseGrant=InternalBaseGrant;class InternalOperationGrant extends InternalBaseGrant{constructor(e,t){super("operationGrant"),this.operation=e,this.node=t}get key(){return`${this.node}.${this.operation}`}}exports.InternalOperationGrant=InternalOperationGrant;class InternalPermissionGrant extends InternalBaseGrant{constructor(e,t){super("permissionGrant"),this.permission=e,this.activity=t}get key(){return`${this.activity}.${this.permission}`}}exports.InternalPermissionGrant=InternalPermissionGrant;class Activity{#e;#t;#n=Object.create(null);#r;#a;#i;constructor(e){this.definition=e,this.#r=e.permissions,this.#a=e.permissionGrants,this.#i=e.operationGrants}get description(){return this.definition.description}get node(){return this.definition.node()}get noCascadeNodes(){return this.definition.noCascadeNodes?this.definition.noCascadeNodes():[]}get name(){if(!this.#t)this.#t=_.camelCase(fsp.basename(this.definition.__filename).replace(/\.(js|ts)$/,""));return this.#t}get permissions(){return this.#r}get operationGrants(){return this.#i}get permissionGrants(){return this.#a}get package(){return this.#e}set package(e){this.#e=e}#s=Object.create(null);set flattenedPermissions(e){this.#s=e}get flattenedPermissions(){return this.#s}mergeExtension(e){e.permissions.forEach(e=>{if(!this.#r.includes(e))this.#r.push(e)}),this.#a=_.mergeWith(this.#a,e.permissionGrants,(e,t)=>{if(_.isArray(e)||_.isArray(t))return _.uniqWith([...e||[]].concat(t||[]),_.isEqual);return}),this.#i=_.mergeWith(this.#i,e.operationGrants,(e,t)=>{if(_.isArray(e)||_.isArray(t))return _.uniqWith([...e||[]].concat(t||[]),_.isEqual);return})}addGrant(e,t){if(null==this.#n[e])this.#n[e]=Object.create(null);const n=this.#n[e];if(null==n[t.key])return n[t.key]=t,true;return false}get internalGrants(){return this.#n}addNodeOperation(e,t){if(activity_manager_1.ActivityManager.checkOperation(this.name,t,e))if(this.addGrant(t,new InternalOperationGrant(t,e.name)),["create","update","delete","read"].includes(t)){if("read"!==t)this.addGrant(t,new InternalPermissionGrant("read",this.name));this.addGrant(t,new InternalPermissionGrant("lookup",this.name))}}fillFactoryGrants(e){const{operationGrants:t,permissionGrants:n,permissions:r}=this;if(r.forEach(t=>this.addNodeOperation(e,t)),t)Object.keys(t).forEach(n=>{this.addNodeOperation(e,n),t[n].forEach(e=>{e.operations.forEach(t=>{(e.on||[()=>this.node]).forEach(e=>{this.addGrant(n,new InternalOperationGrant(t,e().name))})})})});if(n)Object.keys(n).forEach(t=>{if(activity_manager_1.ActivityManager.checkOperation(this.name,t,e))this.addGrant(t,new InternalOperationGrant(t,e.name));n[t].forEach(e=>{e.permissions.forEach(n=>{e.on.forEach(e=>{this.addGrant(t,new InternalPermissionGrant(n,e().name))})})})});this.permissions.forEach(t=>{if(activity_manager_1.ActivityManager.checkOperation(this.name,t,e))this.addGrant(t,new InternalOperationGrant(t,this.node.name))})}fillInternalGrants(e){const t=e.getFactoryByName(this.node.name);if(this.fillFactoryGrants(t),t.isAbstract)e.getAllFactories().filter(e=>e.isSubNodeOf(t.name)).forEach(e=>{this.fillFactoryGrants(e)})}fillInheritedInternalGrants(e,t){const n=Object.entries(this.#n);for(const[r,a]of n){const n=Object.values(a).filter(e=>e.isOperationGrant());if(this.addOperationGrants(e,Object.values(n),r,t))return true}return false}addOperationGrants(e,t,n,r){for(const a of t){const t=e.getFactoryByName(a.node);if(["create","update","delete","read","lookup"].includes(a.operation)){if("lookup"!==a.operation){if("read"!==a.operation&&this.addGrant(n,new InternalOperationGrant("read",a.node)))return true;if(this.addGrant(n,new InternalOperationGrant("lookup",a.node)))return true}if(this.addExtendedVitalFactoriesGrants(t,a,n))return true}if("lookup"!==a.operation){const e=r[t.name]??t.properties.filter(e=>e.isForeignNodeProperty()&&(e.isReferenceProperty()&&e.canLookup||!e.isReferenceProperty())&&!system_properties_1.SystemProperties.isUserManagementProperty(e)&&!system_properties_1.SystemProperties.isAttachmentsProperty(e)&&!system_properties_1.SystemProperties.isNotesProperty(e)&&!e.isVitalParent).map(e=>e.targetFactory);if(!r[t.name])r[t.name]=e;for(const t of e)if(this.addGrant(n,new InternalOperationGrant("lookup",t.name)))return true}}return false}addExtendedVitalFactoriesGrants(e,t,n){const r=this.definition.noCascadeNodes?.()?this.definition.noCascadeNodes().map(e=>e.name):null,a=e.extendedVitalFactories.filter(e=>!r||!r.includes(e.name));for(const e of a){if(this.addGrant(n,new InternalOperationGrant(t.operation,e.name)))return true;switch(t.operation){case"lookup":break;case"read":if(this.addGrant(n,new InternalOperationGrant("lookup",e.name)))return true;break;default:if(this.addGrant(n,new InternalOperationGrant("read",e.name))||this.addGrant(n,new InternalOperationGrant("lookup",e.name)))return true}}return false}getLocalizedTitleKey(){return`${this.#e}/activity__${_.snakeCase(this.name)}__name`}getPermissionLocalizedTitleKey(e){return`${this.#e}/permission__${_.snakeCase(e)}__name`}}exports.Activity=Activity;
//# sourceMappingURL=activity.js.map