/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Test=void 0,exports.mapGraphQlResult=mapGraphQlResult;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_shared_1=require("@sage/xtrem-shared"),chai_1=require("chai"),fs=require("fs"),fsp=require("path"),application_1=require("../application"),graphql_1=require("../graphql"),metadata_schema_1=require("../graphql/metadata-schema"),node_state_1=require("../node-state"),context_1=require("../runtime/context"),loggers_1=require("../runtime/loggers"),table_1=require("../sql/schema/table"),condition_variable_1=require("./condition-variable"),mocker_1=require("./mocker"),tables_1=require("./tables"),test_reset_tables_1=require("./test-reset-tables"),logger=loggers_1.loggers.test;function makeUserTestOption(t,e){const a={skipMocks:true,testActiveServiceOptions:e};if(t.user)a.user={email:t.user,userName:""};if(t.cookie){const e={tenantId:t.tenantId||Test.defaultTenantId,...t.auth};if(a.config={response:{constructor:{name:"ServerResponse"},cookie:"function"==typeof t.cookie?t.cookie:()=>{},locals:{auth:e}}},e.login)a.user={email:e.login,userName:""}}else if(t.auth)a.auth=t.auth;if(t.tenantId)a.config={...a.config,tenantId:t.tenantId};return a}const getSetupModule=t=>{if(!fs.existsSync(fsp.join(t,"test/setup.ts")))return;return delete require.cache[require.resolve(fsp.join(t,"test/setup.ts"))],require(fsp.join(t,"test/setup"))};function runSetup(t){const e=getSetupModule(t);if(e)if("function"==typeof e.setup)e.setup();else console.warn(`'setup.ts' file under '${fsp.join(t,"test/graphql")}' does not contain any function called 'setup'!`)}const applyContextMocks=async(t,e)=>{if(e.locale)await t.setTestLocale(e.locale);if(e.currentLegislationCode)t.currentLegislationCode=e.currentLegislationCode};class Test{static{this._schemaExists={}}static{this.defaultTenantId="7".repeat(21)}static{this.defaultEmail="unit.test@acme.com"}static{this.lastCommitTimestamp=null}static{this.defaultTenantName="Tenant for tests (automatic creation)"}static get application(){return this._application}static set application(t){this._application=t}static async ensureTestTenantExists(t){if("@sage/xtrem-cop-test"===t.application.mainPackage.name)return;await context_1.Context.tenantManager.ensureTenantExists(t,{tenant:{id:Test.defaultTenantId,name:Test.defaultTenantName},customer:{id:Test.defaultTenantId,name:"Customer for tests (automatic creation)"}})}static withCommittedContext(t,e){const wrappedBody=e=>(e.on("closed",()=>{logger.debug(()=>`Test writable context closed: ${e.lastCommitTimestamp}`),Test.lastCommitTimestamp=e.lastCommitTimestamp}),t(e));return Test.application.withCommittedContext(e?.tenantId||Test.defaultTenantId,wrappedBody,e)}static withUncommittedContext(t,e){return Test.application.withUncommittedContext(e?.tenantId||Test.defaultTenantId,t,e)}static withReadonlyContext(t,e){const a={...e,lastCommitTimestamp:Test.lastCommitTimestamp??void 0},wrappedBody=e=>(logger.debug(()=>`Test readonly context closed: ${e.lastCommitTimestamp}`),e.on("closed",()=>{Test.lastCommitTimestamp=e.lastCommitTimestamp}),t(e));return Test.application.withReadonlyContext(e?.tenantId||Test.defaultTenantId,wrappedBody,a)}static get state(){return this._state}static set state(t){this._state=t}static get options(){if(!this.application)throw new Error("invalid test context: Test.application is undefined");return{config:{...xtrem_config_1.ConfigManager.current,...this._config},application:this.application}}static patchConfig(t){this._config={...this._config,...t}}static configForTest(){return this._config}static fixRequestMiddleWare(t,e,a){e.locals.config=xtrem_config_1.ConfigManager.current,e.locals.context={email:Test.defaultEmail,tenantId:Test.defaultTenantId},e.locals.auth={...e.locals.auth,login:e.locals.context.email,tenantId:e.locals.context.tenantId,auth0:"auth0"},a()}static convertOptions(t){const e=this.options,a="unit.test@acme.com",i=["setup","test"],s=t?.config?.layers||i;if(!e.config)e.config=xtrem_config_1.ConfigManager.current;if(e.config.storage?.managedExternal){const a="ADMIN";e.config.user=t?.user?t.user?.userName||a:t?.config?.userName||a}else{if(!t?.auth?.login)e.config.email=t?.user?t.user?.email||a:t?.config?.email||a,e.userEmail=e.config.email,e.config.user=e.config.email;e.auth=t?.auth}return e.response=t?.config?.response||{},e.request=t?.config?.request||{},e.testNowMock=t?.now||"",e.source=t?.source,e.testLayers=s,e.testMode=true,e.testConfig=t&&{...t},e.locale=t?.locale||"base",e.noLazyLoading=t?.noLazyLoading,e.testActiveServiceOptions=this.getTestActiveServiceOptions(t),e.tenantId=t?.tenantId,e.timeLimitAsTimestamp=t?.timeLimitAsTimestamp,e}static isServiceOptionEnabledByTestConfig(t){const e=this._config?.serviceOptions?.level;if("released"===e)return"released"===t.status;if("experimental"===e)return"workInProgress"!==t.status;return true}static getTestActiveServiceOptions(t){const e=[],addServiceOption=t=>{if(!e.includes(t))e.push(t);if(t.activates)t.activates().forEach(addServiceOption)};if(t?.testActiveServiceOptions)t.testActiveServiceOptions.forEach(addServiceOption);else{if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)return;if(Object.values(this.application.serviceOptionsByName).filter(t=>t.isActiveByDefault).forEach(addServiceOption),Test.cliActiveServiceOptions)Test.cliActiveServiceOptions.forEach(addServiceOption)}return e.filter(t=>this.isServiceOptionEnabledByTestConfig(t))}static createPlugins(t){if(!t?.mocks)return t;if(!t?.directory)throw new Error("Mocks provided without a directory.");if(t.directory=t.directory.replace(`${fsp.sep}build${fsp.sep}`,fsp.sep),!t?.scenario)t.scenario=fsp.parse(t.directory).name;if(chai_1.assert.isArray(t.mocks,"mocks must be an array."),t.plugins=t.plugins||[],t.mocks)t.plugins.map(t=>t.name).forEach(e=>{if(t.mocks?.includes(e))throw new Error(`Cannot mock and supply a plugin for the same module, ${e}`)});return t.plugins=[...t.plugins,...t.mocks.map(e=>{const a=mocker_1.mockPlugins[e];return chai_1.assert.exists(a,`No plugin found for '${e}' mock.`),new a(e,fsp.join(t.directory,e),t.scenario)})],t}static async preliminarySteps(t){if(t.directory)t.directory=t.directory.replace(`${fsp.sep}build${fsp.sep}`,fsp.sep);Test.applyDateMocks(t);const e=this.createPlugins(t),a=this.convertOptions(e);if(!a.config)a.config=xtrem_config_1.ConfigManager.current;if(!a.config.storage?.managedExternal){const t=this.application.schemaName;if(!Test._schemaExists[t])Test._schemaExists[t]=true,await application_1.Application.createDbSchema(t)}return{testOptions:e,contextOptions:a}}static withContext(t,e={}){const isInvalid=t=>{if(t.baseFactory&&t.baseFactory.table&&isInvalid(t.baseFactory))return true;return t.table&&t.table.testStatus!==table_1.TestStatus.loaded},a=Test.application.getSqlPackageFactories().filter(isInvalid);return this.withMocks(async(e,i)=>(await(0,xtrem_async_helper_1.asyncArray)(a).forEach(async t=>{try{await t.fixAutoIncrementSequences(null)}catch{logger.warn(`Could not fix auto increment sequence for ${t.name}`)}t.table.testStatus=table_1.TestStatus.loaded}),Test.withUncommittedContext(a=>Test.withContextMocks(a,{testOptions:e,contextOptions:i},()=>t(a)),i)),e)}static async withMocks(t,e={}){const{testOptions:a,contextOptions:i}=await this.preliminarySteps(e);try{return await t(a,i)}finally{if(this._timeStubs)Test.restoreDateMocks()}}static async withCommittedServiceOptions(t,e,a){if(!a.length)return e();const i=await this.application.asRoot.withCommittedContext(t,async t=>{const e=await(0,xtrem_async_helper_1.asyncArray)(a).filter(async e=>!await t.isServiceOptionEnabled(e)).toArray();return this.application.serviceOptionManager.activateServiceOptions(t,e)});try{return await e()}finally{await this.application.asRoot.withCommittedContext(t,t=>this.application.serviceOptionManager.deactivateServiceOptions(t,i))}}static withUserContext(t,e,a){const i=this.convertOptions({skipMocks:true,testActiveServiceOptions:a});return this.withCommittedServiceOptions(i.tenantId||Test.defaultTenantId,()=>Test.withContext(t,makeUserTestOption(e,a)),a||[])}static readonly(t,e={}){return this.withMocks((e,a)=>Test.withReadonlyContext(i=>Test.withContextMocks(i,{testOptions:e,contextOptions:a},()=>t(i)),a),e)}static committed(t,e={}){return this.withMocks((e,a)=>Test.withCommittedContext(i=>Test.withContextMocks(i,{testOptions:e,contextOptions:a},()=>t(i)),a),e)}static uncommitted(t,e={}){return this.withMocks((e,a)=>Test.withUncommittedContext(i=>Test.withContextMocks(i,{testOptions:e,contextOptions:a},()=>t(i)),a),e)}static async setup(t){const e=xtrem_config_1.ConfigManager.load(t.dir,"test");if(!e.storage?.managedExternal){const e=Date.now();await application_1.Application.createDbSchema(t.schemaName),logger.info(`created application schema ${t.schemaName} (${Date.now()-e} ms)`)}this.application=t,t.getAllNodes()}static{this.getTestSchemaName=t=>`${require(fsp.resolve(t,"package.json")).name.replace(/@[a-z][a-z0-9.-]*\//,"").replace(/[-~]/g,"_")}_test`}static{this.getDirectory=(t,e)=>{const a=fsp.join(t,e);if(fs.existsSync(a)&&!fs.statSync(a).isDirectory())return t;return""}}static async createCliApplication(t){if(t.api)t.api={...t.api,nodes:{...t.api.nodes}};const e=fsp.resolve(t.buildDir,"..");xtrem_config_1.ConfigManager.load(e);return await application_1.Application.create({schemaName:this.getTestSchemaName(e),applicationType:"dev-tool",...t})}static async createTestApplication(t){xtrem_config_1.ConfigManager.load(__dirname);const e=await application_1.Application.create({schemaName:t.schemaName||xtrem_config_1.ConfigManager.current.storage?.managedExternal?"xtrem_external":this.getTestSchemaName(fsp.resolve(t.buildDir,"..")),applicationType:"test",...t});if(xtrem_config_1.ConfigManager.current.storage?.managedExternal)return e;const a={testLayers:["setup","test"],userEmail:context_1.rootUserEmail,withoutTransactionUser:true};return e.activityManager.resolvePermissions(),await test_reset_tables_1.TestResetTables.resetTestTables(e,a),e.startListeners(["testListen"]),e}static async setupApi(t,e){return await Test.setup(t),e.use((t,e,a)=>{e.locals.config=xtrem_config_1.ConfigManager.current,e.locals.config.email=e.locals.config.email||"unit.test@acme.com",a()}),t}static initializeManagers(t){context_1.Context.managers.forEach(e=>e.initializeManager(t))}static async cleanUp(t){const e=t.getAllSortedFactories().slice().reverse();await(0,xtrem_async_helper_1.asyncArray)(e).forEach(t=>(0,tables_1.dropTestTable)(t.nodeConstructor))}static applyDateMocks(t){if(this._timeStubs={},t.now&&t.today)throw new xtrem_shared_1.LogicError("specify 'now' or 'today' in test options but not both");if(t.now)xtrem_date_time_1.datetime.overrideNow(t.now);else if(t.today)xtrem_date_time_1.datetime.overrideNow(`${t.today}T12:00:00Z`)}static{this.restoreDateMocks=()=>{xtrem_date_time_1.datetime.overrideNow(null)}}static withContextMocks(t,e,a){if(e.testOptions.skipMocks)return a();return mocker_1.Mocker.withMocks(async()=>(runSetup(t.application.dir),await applyContextMocks(t,e.testOptions),a()),e.testOptions.plugins)}static createConditionVariable(t){return new condition_variable_1.ConditionVariable(t)}static async rollbackCache(t){if("test"!==t.application.applicationType)throw new Error("Cannot rollback cache outside of tests");await t.flushDeferredSaves(),await t.flushDeferredActions(),t.transaction.rollbackCache(),t.prefetcher.reset()}static resetPrefetcher(t){t.prefetcher.reset()}static mapLineNumber(t){return t.replace(/-1000\d{6}/g,"<???>")}static mapDiagnosisPaths(t){return{message:this.mapLineNumber(t.message),path:t.path.map(this.mapLineNumber),severity:t.severity}}static mapDiagnosesPaths(t){return t.map(t=>Test.mapDiagnosisPaths(t))}static assertDeepEqualDiagnoses(t,e){chai_1.assert.deepEqual(this.mapDiagnosesPaths(t),e)}static async graphql(t,e,a){const i=a?.schema??await Test.application.getGraphQLSchema();return new graphql_1.GraphQlHelper(i).execute(t,e,a)}static metadataGraphql(t,e,a){const i=a?.schema??(0,metadata_schema_1.createMetadataSchema)(Test.application);return new graphql_1.GraphQlHelper(i).execute(t,e,a)}static{this.hacks={isNodeStateUpdatable:t=>t.$.state.status===node_state_1.StateStatus.updatable,setNodeStateUpdatable(t){t.$.state.status=node_state_1.StateStatus.updatable}}}}function mapGraphQlResult(t){return t}exports.Test=Test;
//# sourceMappingURL=test.js.map