/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TestResetTables=void 0;const __1=require(".."),application_1=require("../application"),runtime_1=require("../runtime"),loggers_1=require("../runtime/loggers"),sql_1=require("../sql"),test_1=require("./test");class TestResetTables{static async resetTestTables(e,t,a){if(!a?.force&&!await this.resetNeeded(e,t))return;await this._resetTables(e,t)}static async resetTestTableSequences(e,t){(await runtime_1.NodeFactory.fixSequences(e,test_1.Test.defaultTenantId)).forEach(a=>{a.table.markAsLoadedForTests(e,t)})}static resetNeeded(e,t){return e.withReadonlyContext(null,t=>{const a=test_1.Test.state;return!a||e.name!==a.application||JSON.stringify(t.testLayers||[])!==JSON.stringify(a.layers)||(t.testNowMock||"")!==a.nowMock},t)}static async _resetTables(e,t){if(await e.createContextForDdl(e=>e.managedExternal))return;const a=new sql_1.DatabaseSqlContext;loggers_1.loggers.application.warn(`Drop schema ${e.schemaName}`),await a.dropSchemaIfExists(e.schemaName),loggers_1.loggers.application.warn(`Create schema ${e.schemaName}`),await a.createSchemaIfNotExists(e.schemaName),loggers_1.loggers.application.warn(`Create tables for schema ${e.schemaName}`),await e.createContextForDdl(e=>application_1.ApplicationCreateSqlSchema.createTables(e,[]),{description:()=>"Create test tables"}),await e.asRoot.withCommittedContext(null,async t=>{await e.serviceOptionManager.createOrUpdateServiceOptions(t),await e.serviceOptionManager.deleteObsoleteServiceOptions(t)},{description:()=>"resetTables.updateServiceOptions"}),await e.asRoot.withCommittedContext(test_1.Test.defaultTenantId,e=>test_1.Test.ensureTestTenantExists(e),{...t,withoutTransactionUser:true}),await __1.CoreHooks.testManager.initTestTenantActivePackages(e),await e.asRoot.withCommittedContext(test_1.Test.defaultTenantId,async t=>{await runtime_1.Context.accessRightsManager.createActivities(t),await runtime_1.Context.accessRightsManager.updateActivities(t),await runtime_1.Context.accessRightsManager.deleteActivities(t),test_1.Test.state={application:e.name,layers:t.testLayers||[],nowMock:t.testNowMock||""}},t),await __1.CoreHooks.metadataManager.upgradeMetadata(e),await __1.CoreHooks.testManager.loadTestData(e,{testLayers:t.testLayers},test_1.Test.defaultTenantId);e.getAllSortedFactories().forEach(a=>{a.table.markAsLoadedForTests(e,t)})}}exports.TestResetTables=TestResetTables;
//# sourceMappingURL=test-reset-tables.js.map