import { Application } from '../application';
import { ContextOptions } from '../runtime';
export declare abstract class TestResetTables {
    /**
     * This method is called at the beginning of Test.withContext.
     * Its goal is to make sure the database is the exact mirror of the csv files contained in the layers
     * selected for the test.
     *
     * CAUTION: if needed, the schema will be dropped and re-created. Nothing must be written
     * to the database before calling this function otherwise it will be LOST.
     *
     * First we determine if the layers have changed since the previous test.
     *
     *  - If the current package, the layers or the now mock have changed, it is necessary to fully
     *    reload the entire database.
     *
     *  - If not, as all the applicative tests are supposed to be enclosed within a Test.withContext block,
     *    they are executed in uncommitted mode, so previous transactions have been rolled back.
     *    In that case, the only step is to reset the sequences of each table dirtied by a previous test.
     * @param contextOptions
     */
    static resetTestTables(application: Application, contextOptions: ContextOptions, options?: {
        force?: boolean;
    }): Promise<void>;
    /**
     * Reset the sequences for all the tables
     * @param application
     * @param contextOptions
     */
    static resetTestTableSequences(application: Application, contextOptions: ContextOptions): Promise<void>;
    private static resetNeeded;
    private static _resetTables;
}
//# sourceMappingURL=test-reset-tables.d.ts.map