/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.initTables=initTables,exports.dropTables=dropTables,exports.dropTestTable=dropTestTable,exports.restoreTables=restoreTables;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),_=require("lodash"),application_1=require("../application"),index_1=require("../index"),runtime_1=require("../runtime"),loggers_1=require("../runtime/loggers"),schema_1=require("../sql/schema"),user_data_1=require("./manager-mocks/user-data"),tablesToClear=[];async function initTables(e,t){if(loggers_1.loggers.test.info(`Initializing test tables (${e.map(e=>e.nodeConstructor.name)})`),!index_1.Test.application)throw new Error("cannot call initTables: Test.application is not set (forgot to call setup?)");const a=t?.skipUsers?e:[{nodeConstructor:index_1.CoreHooks.sysManager.getUserNode(),data:user_data_1.userData.map(e=>_.omit(e,["_id"])),forceDelete:true},...e];await index_1.Test.application.createContextForDdl(e=>(0,xtrem_async_helper_1.asyncArray)(a).forEach(async t=>{const a=index_1.Test.application.getFactoryByConstructor(t.nodeConstructor);if(await a.table.tableExists(e))await dropTestTable(t.nodeConstructor,t.forceDelete)}),{...index_1.Test.convertOptions(void 0),description:()=>"Drop test tables"}),await _fillTables(index_1.Test.application,a.map(e=>({factory:index_1.Test.application.getFactoryByConstructor(e.nodeConstructor),data:e.data})))}async function _fillTables(e,t){index_1.Test.state={application:"Test app",layers:[],nowMock:""},await index_1.Test.application.createContextForDdl(e=>application_1.ApplicationCreateSqlSchema.verifyAndCreateTables(e),{description:()=>"Verify and create tables"}),await index_1.Test.withCommittedContext(e=>index_1.Test.ensureTestTenantExists(e),{userEmail:runtime_1.rootUserEmail,withoutTransactionUser:true,description:()=>"Ensure test tenant exists"}),await(0,xtrem_async_helper_1.asyncArray)(t).forEach(async e=>{await index_1.Test.withCommittedContext(async t=>{const a=e.factory.table;let r=e.data;if(e.factory.name===index_1.CoreHooks.sysManager.getUserNode().name)r=e.data.filter(e=>e.email!==runtime_1.rootUserEmail);if(!tablesToClear.includes(a))tablesToClear.push(a);let s=a.baseTable;for(;s;){if(!tablesToClear.includes(s))tablesToClear.push(s);s=s.baseTable}const o=index_1.SystemProperties.idProperty(a.factory).columnName||"";await(0,xtrem_async_helper_1.asyncArray)(r).forEach(async e=>{if(await(0,xtrem_async_helper_1.asyncArray)(Object.keys(e)).forEach(async r=>{const s=e[r],o=a.factory.propertiesByName[r];if("function"==typeof s)e[r]=e[r]();else if(o?.isStringProperty()&&o.isStoredEncrypted)e[r]=t.vault.recordValue(await t.vault.encrypt(s));else if(o?.isReferenceProperty()&&"string"==typeof s&&"#"===s[0])e[r]=await o.targetFactory.resolveReferenceId(t,s)}),!e._customData)e._customData={};const r=await a.insert(t,e);if(null!=r[o])e._id=r[o]}),a.markAsModifiedForTests()},index_1.Test.convertOptions({user:{email:runtime_1.rootUserEmail}})),await e.factory.fixAutoIncrementSequences(null)})}async function dropTables(e,t){await index_1.Test.withCommittedContext(e=>(0,xtrem_async_helper_1.asyncArray)(t).forEach(t=>t.table.dropTable(e,{ifExists:true,cascade:true})))}async function dropTestTable(e,t=false){const a=index_1.Test.application.getFactoryByConstructor(e),r=a.table;if((r.name.startsWith("sys_")||r.name.startsWith("system_"))&&!t)return;if(!r.name.startsWith("test_")&&!t)throw new Error(`${r.name}: Can only drop 'test_*' tables`);await index_1.Test.withReadonlyContext(async e=>{if(a.baseFactory&&await a.baseFactory.table.tableExists(e))await dropTestTable(a.baseFactory.nodeConstructor);if(await r.dropTable(e,{ifExists:true,cascade:true}),await r.tableExists(e))throw new Error(`The table ${r.name} could not be dropped`)},index_1.Test.convertOptions(void 0))}async function restoreTables(){await(0,xtrem_async_helper_1.asyncArray)(tablesToClear.filter(e=>e.testStatus===schema_1.TestStatus.modified)).forEach(e=>dropTestTable(e.factory.nodeConstructor)),tablesToClear.length=0}
//# sourceMappingURL=tables.js.map