/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.mockPlugins=exports.AxiosPlugin=exports.Mocker=exports.Plugin=void 0;const xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_shared_1=require("@sage/xtrem-shared"),chai_1=require("chai"),fs=require("fs"),_=require("lodash"),fsp=require("path");class Plugin{constructor(e,t,s){this.name=e,this.path=t,this.scenario=s}mock(){throw new Error("Must implement mock!")}}exports.Plugin=Plugin;class Mocker{static{this.plugins=new Map}static addPlugin(e){Mocker.plugins.set(e.name,e)}static async withMocks(e,t=[]){if(0===t.length)return e();t.forEach(e=>{Mocker.addPlugin(e)});try{return await e()}finally{Mocker.plugins.clear()}}static get(e,t){return Mocker.plugins.get(e)?.mock()||t(e)}}exports.Mocker=Mocker;const locateFirstDiff=(e,t)=>{let s=1,i=1;for(let r=0;r<e.length;r+=1){if(e[r]!==t[r])return{line:s,column:i};if("\n"===e[r])s+=1,i=1;else i+=1}return{line:s,column:i}};function deepDiff(e,t){if("object"!=typeof e||"object"!=typeof t)return[];return _.reduce(e,(e,s,i)=>{const r=t[i];return _.isEqual(s,r)?e:e.concat({key:i,actual:s,expected:r},deepDiff(s,r))},[])}class AxiosPlugin extends Plugin{constructor(){super(...arguments),this.arrayCounter=0}mock(){return e=>{if(e.headers?.Authorization)delete e.headers.Authorization;const t=`${fsp.join(this.path,this.scenario)}.json`;if(null==this.entries){chai_1.assert.isTrue(fs.existsSync(t),`Couldn't find mandatory '${t}' file.`);const e=fs.readFileSync(t,"utf8");chai_1.assert.isDefined(e,`Couldn't read '${t}'.`);const s=(0,xtrem_shared_1.tryJsonParse)(e);chai_1.assert.exists(s,`'${t}' is not a valid JSON file.`),this.entries=!Array.isArray(s)?[s]:s}chai_1.assert.isAtMost(this.arrayCounter,this.entries.length-1,`'${t}' not all requests are a provided.`);const s=this.entries[this.arrayCounter];chai_1.assert.exists(s.request,`'${t}' must contain a 'request' key'.`),chai_1.assert.exists(s.response,`'${t}' must contain a 'response' key'.`);const i=JSON.parse(JSON.stringify(e)),r=s.request;try{chai_1.assert.deepEqual(i,r)}catch{const n=fsp.join(this.path,"tmp"),a=JSON.stringify({...s,request:i},null,4),o=JSON.stringify({...s,request:r},null,4),{line:c,column:u}=locateFirstDiff(a,o),l=`${xtrem_date_time_1.Datetime.now(true).toString()}-${_.snakeCase(this.scenario)}`;fs.mkdirSync(n,{recursive:true}),fs.writeFileSync(fsp.join(n,`${l}-actual.json`),a,"utf8"),fs.writeFileSync(fsp.join(n,`${l}-expected.json`),o,"utf8");const f=deepDiff(e,r),h=f.slice(-1)[0],p=`AXIOS MOCKER FAILED\n- Mock file: ${t}.\n- Details in ${n}/${l}-{actual,expected}.json files.\n- Diff starts at line ${c}, column ${u}\nin ${f.map(e=>e.key).join(".")}`;throw fs.writeFileSync(fsp.join(n,`${l}-actual-diff-value.txt`),JSON.stringify(h.actual),"utf8"),fs.writeFileSync(fsp.join(n,`${l}-expected-diff-value.txt`),JSON.stringify(h.expected),"utf8"),new xtrem_shared_1.LogicError(p)}return this.arrayCounter+=1,s.response}}}exports.AxiosPlugin=AxiosPlugin,exports.mockPlugins={axios:AxiosPlugin};
//# sourceMappingURL=mocker.js.map