/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";var __decorate=this&&this.__decorate||function(e,t,r,s){var a,o=arguments.length,i=o<3?t:null===s?s=Object.getOwnPropertyDescriptor(t,r):s;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(e,t,r,s);else for(var c=e.length-1;c>=0;c--)if(a=e[c])i=(o<3?a(i):o>3?a(t,r,i):a(t,r))||i;return o>3&&i&&Object.defineProperty(t,r,i),i};Object.defineProperty(exports,"__esModule",{value:true}),exports.accessRightsManagerMock=exports.TestActivity=exports.TestUser=exports.serviceOptionsMock=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),_=require("lodash"),decorators_1=require("../../decorators"),runtime_1=require("../../runtime"),core_hooks_1=require("../../runtime/core-hooks"),ts_api_1=require("../../ts-api"),types_1=require("../../types"),service_options_1=require("../service-options"),test_user_type_enum_1=require("./test-user-type-enum"),user_data_1=require("./user-data");exports.serviceOptionsMock={isDemoTenant:service_options_1.isDemoTenant};const dataTypes={name:new types_1.StringDataType({maxLength:80}),email:new types_1.StringDataType({maxLength:320})};let TestUser=class TestUser extends ts_api_1.Node{async toUserInfo(){return{_id:this._id,email:await this.email,isActive:await this.isActive,userType:await this.userType,firstName:await this.firstName,lastName:await this.lastName,isAdministrator:await this.isAdministrator,isApiUser:await this.isApiUser,isDemoPersona:await this.isDemoPersona,userName:await this.email}}};exports.TestUser=TestUser,__decorate([decorators_1.decorators.stringProperty({isStored:true,isFrozen:true,isPublished:true,isNotEmpty:true,dataType:()=>dataTypes.email})],TestUser.prototype,"email",void 0),__decorate([decorators_1.decorators.booleanProperty({isStored:true})],TestUser.prototype,"isFirstAdminUser",void 0),__decorate([decorators_1.decorators.stringProperty({isStored:true,isPublished:true,isNotEmpty:true,dataType:()=>dataTypes.name})],TestUser.prototype,"firstName",void 0),__decorate([decorators_1.decorators.stringProperty({isStored:true,isPublished:true,isNotEmpty:true,dataType:()=>dataTypes.name})],TestUser.prototype,"lastName",void 0),__decorate([decorators_1.decorators.booleanProperty({isStored:true,isPublished:true,defaultValue:true})],TestUser.prototype,"isActive",void 0),__decorate([decorators_1.decorators.stringProperty({isPublished:true,async getValue(){return`${await this.lastName}, ${await this.firstName}`}})],TestUser.prototype,"displayName",void 0),__decorate([decorators_1.decorators.enumProperty({isPublished:true,isStored:true,dataType:()=>test_user_type_enum_1.TestUserTypeDataType,defaultValue:"application"})],TestUser.prototype,"userType",void 0),__decorate([decorators_1.decorators.booleanProperty({isStored:true,isPublished:true,defaultValue:false})],TestUser.prototype,"isAdministrator",void 0),__decorate([decorators_1.decorators.booleanProperty({isStored:true,isPublished:true,defaultValue:false,serviceOptions:()=>[exports.serviceOptionsMock.isDemoTenant]})],TestUser.prototype,"isDemoPersona",void 0),__decorate([decorators_1.decorators.booleanProperty({isStored:true,isPublished:true,defaultValue:false})],TestUser.prototype,"isApiUser",void 0),exports.TestUser=TestUser=__decorate([decorators_1.decorators.node({storage:"sql",canRead:true,canCreate:true,canUpdate:true,canDelete:true,isPublished:true,indexes:[{orderBy:{email:1},isUnique:true,isNaturalKey:true}],isSetupNode:true})],TestUser);let TestActivity=class TestActivity extends ts_api_1.Node{};async function checkCanWait(){await new Promise(e=>{e()})}exports.TestActivity=TestActivity,__decorate([decorators_1.decorators.stringProperty({isStored:true,isFrozen:true,isPublished:true,dataType:()=>dataTypes.name})],TestActivity.prototype,"name",void 0),exports.TestActivity=TestActivity=__decorate([decorators_1.decorators.node({storage:"sql",isPublished:true,canCreate:true,canRead:true,canUpdate:true,canDelete:true,canDeleteMany:true,tableName:"Activity",indexes:[{orderBy:{name:1},isUnique:true,isNaturalKey:true}],isSetupNode:true,isSharedByAllTenants:true,isPlatformNode:true})],TestActivity);const userMap=user_data_1.userData.reduce((e,t)=>(e[t.email]=t,e),{});exports.accessRightsManagerMock={async getUserAccessFor(e,t,r="",s){await checkCanWait();const a={create:"C",update:"M",delete:"S",read:""}[r]||r,o=s?.authorizationCode||e.application.getFactoryByName(t)?.authorizationCode,i={sites:null,accessCodes:null,status:"authorized"},c=(await e.user)?.email;if("TestFish"===t&&"access_1_2.auth@acme.com"===c&&"read"===r)return{sites:null,accessCodes:null,status:"unauthorized"};switch(o){case"FCT1":if(!["C","M","Y","createOperation","lookup"].includes(a))i.status="unauthorized",i.sites=[];break;case"SECURE":switch(c){case"site_1_3.auth@acme.com":i.sites=["1","3"];break;case"all.auth@acme.com":default:break;case"none.auth@acme.com":i.sites=[];break;case"user1.test@acme.com":i.status="unauthorized",i.sites=[];break;case"foo.test@acme.com":switch(r){case"read":case"lookup":break;case"site":i.status="readonly",i.sites=[];break;case"access":case"pageExtension":i.status="unavailable",i.sites=[];break;case"code":i.status="TestSecure"===t?"readonly":"unauthorized";break;default:i.status="unauthorized"}}break;case"LOOKUP":if("lookup.access@test.com"===c)switch(r){case"lookup":case"code":break;default:i.status="unauthorized"}}switch(c){case"access_1_2.auth@acme.com":i.accessCodes=["ACCESS1","ACCESS2"];break;case"all.auth@acme.com":default:i.accessCodes=null;break;case"none.auth@acme.com":i.accessCodes=[]}return i},isAccessCodeAvailable:(e,t)=>"RESTRICTED"!==t,getOperationSecurityFilter:(e,t,r)=>Promise.resolve(void 0),async createAdminUser(){},async createRequiredUsers(e){const t=this.getUserNode(),r=e.application.getFactoryByName(t.name);if("external"===r.storage)return;await(0,xtrem_async_helper_1.asyncArray)(user_data_1.userData.filter(e=>e.isRequired)).forEach(async s=>{const a={...s};if(!await e.tryRead(t,{email:a.email})){const s=a.userType;if("system"===s)a.userType="application";const o=await e.create(t,_.omit(a,["_id"]));if(await o.$.save(),"system"===s){const t=`UPDATE ${e.schemaName}.${r.tableName} SET _id = 1, _create_user = 1, _update_user = 1, user_type = $1 WHERE email = $2 AND _tenant_id = $3`;await e.executeSql(t,["system",a.email,e.tenantId])}}})},ensureAdminPersonaCreated:e=>runtime_1.adminDemoPersona,async getUser(e,t){if(await checkCanWait(),"external"===e.application.getFactoryByConstructor(this.getUserNode()).storage){const e=userMap[t&&t.toLowerCase()];if(!e)throw new Error(`User '${t}' not found`);return e}const r=await e.tryRead(this.getUserNode(),{email:t});if(!r)throw new Error(`User '${t}' not found`);return r.toUserInfo()},async getCurrentUser(e){try{const t=await e.user;if(!t)return await e.rootUser;return{_id:String(t._id),email:t.email}}catch{return e.rootUser}},getUserNode:()=>core_hooks_1.CoreHooks.sysManager.getUserNode(),getPermissions:(e,t)=>["create","read","update","delete","lookup"],createActivities(){return},updateActivities(){return},deleteActivities(){return},getActivityNode:()=>TestActivity,async getActivitiesInfo(e){const t=await e.query(TestActivity).toArray();return await(0,xtrem_async_helper_1.asyncArray)(t).map(async e=>({_id:e._id,name:await e.name})).toArray()},supportsPersona:e=>e.isServiceOptionEnabled(exports.serviceOptionsMock.isDemoTenant),getPersonaUser(e,t){const r=userMap[t.toLowerCase()];return r.isDemoPersona?r:null},async getDemoPersonas(e){if(!await this.supportsPersona(e))return[];const t=await e.loginUser;if(!t)return[];const r=t.isAdministrator?await e.query(TestUser,{filter:{isDemoPersona:true,isAdministrator:true}}).toArray():[],s=await e.query(TestUser,{filter:{isDemoPersona:true,isAdministrator:false}}).toArray();return(0,xtrem_async_helper_1.asyncArray)([...r,...s]).map(e=>e.toUserInfo()).toArray()},invalidateAuthorizationCache:e=>e.invalidateCachedCategory("AUTHORIZATION",{}),isAuthorizationServiceOptionEnabled:e=>false};
//# sourceMappingURL=access-rights-manager-mock.js.map