/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ClientService=exports.ClientArtifactType=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_i18n_1=require("@sage/xtrem-i18n"),crypto_1=require("crypto"),lodash_1=require("lodash"),access_rights_1=require("../../graphql/security/access-rights"),runtime_1=require("../../runtime"),context_1=require("../../runtime/context"),loggers_1=require("../../runtime/loggers"),artifact_manager_1=require("../artifact-manager");var ClientArtifactType;!function(e){e.pages="pages",e.widgets="widgets",e.stickers="stickers",e.strings="strings",e.pageExtensions="page-extensions",e.pageFragments="page-fragments"}(ClientArtifactType||(exports.ClientArtifactType=ClientArtifactType={}));class ClientService{static async getUniqueUserId(e){if((await e.loginUser)?.email)return(0,crypto_1.createHash)("sha256").update(`${(await e.loginUser)?.email}_${xtrem_config_1.ConfigManager.current.telemetrySalt||""}`).digest("base64");return null}static getUniqueTenantId(e){if(e.tenantId&&e.configuration)return(0,crypto_1.createHash)("sha256").update(`${e.tenantId}_${xtrem_config_1.ConfigManager.current.telemetrySalt||""}`).digest("base64");return null}static async getDefaultUserEncryptionKey(e){if((await e.user)?.email){const t=await ClientService.getUniqueUserId(e),a=ClientService.getUniqueTenantId(e);return(0,crypto_1.createHash)("sha256").update(`${t}_${xtrem_config_1.ConfigManager.current.telemetrySalt||""}_${a}`).digest("base64")}return null}static{this.compareSitemapEntries=(e,t)=>(void 0===e.priority?Number.MAX_SAFE_INTEGER:e.priority)-(void 0===t.priority?Number.MAX_SAFE_INTEGER:t.priority)}static{this.populateSitemapLeafChildren=(e,t)=>{if(t[e.id]){const a=t[e.id].map(e=>ClientService.populateSitemapLeafChildren(e,t));a.sort(ClientService.compareSitemapEntries),e.children=a}return e}}static async getSitemapTree(e){if(!ClientService.sitemapTree)ClientService.sitemapTree=await ClientService.calculateSitemapTree(e);return ClientService.sitemapTree}static async calculateSitemapTree(e){loggers_1.loggers.application.debug(()=>"calculateSitemapTree");const t={};loggers_1.loggers.application.debug(()=>"calculateSitemapTree queryPackArtifacts"),(await artifact_manager_1.ArtifactManager.queryPackArtifacts(e,{dataType:"meta"})).forEach(e=>{loggers_1.loggers.application.debug(()=>`calculateSitemapTree artifact package=${e.packageName} path=${e.path}`);const a=artifact_manager_1.ArtifactManager.getParsedContent(e);if(a.parentMenuItem)t[a.parentMenuItem]=[...t[a.parentMenuItem]||[],{id:`${e.packageName}/${a.className}`,isPage:true,priority:a.priority,packageName:e.packageName}]});const a={},r=(0,xtrem_i18n_1.getLocaleFromHeader)(e.request.headers);e.application.getPackages().forEach(e=>{if(e.api?.menuItems)Object.values(e.api.menuItems).forEach(i=>{a[i.id]={...i,packageName:e.name,title:(0,xtrem_i18n_1.getLiteral)(`${e.name}/menu_item__${(0,lodash_1.kebabCase)(i.id.replace(`${e.name}`,""))}`,r).content};const s={...i,packageName:e.name};if(s.parentMenuItem)t[s.parentMenuItem.id]=[...t[s.parentMenuItem.id]||[],{id:i.id,priority:i.priority,icon:i.icon,isPage:false,packageName:e.name}]})});const i=Object.values(a).filter(e=>!!e.icon).map(e=>ClientService.populateSitemapLeafChildren({...e,isPage:false},t));return loggers_1.loggers.application.debug(()=>`calculateSitemapTree tree (before sorting):${JSON.stringify(i,null,"\t")}`),i.sort(ClientService.compareSitemapEntries),loggers_1.loggers.application.debug(()=>`calculateSitemapTree menuItemIdMap (after sorting):${JSON.stringify(a,null,"\t")}`),i}static async searchClientArtifactsFromStorage(e,t,a,r){return(await artifact_manager_1.ArtifactManager.listAllClientArtifactsFromStorage(e,t)).filter(e=>!a.packageOrPage||e.key.startsWith(a.packageOrPage)).filter(e=>!a.pageNode||e.pageNode===a.pageNode).map(e=>({...e,title:(0,xtrem_i18n_1.getLiteral)(`${e.packageName}/${t}__${(0,lodash_1.snakeCase)(e.className)}____title`,r).content}))}static async getAccessStatuses(e,t,a){if(!t)return[];const r=[];return await(0,xtrem_async_helper_1.asyncArray)(Object.entries(t)).forEach(async([t,i])=>{r.push({node:t,bindings:await((0,xtrem_async_helper_1.asyncArray)(i||[])?.map(async r=>({name:r,status:await this.getAccessStatus(e,t,r,t===a?.pageAccess?.node?{authorizationCode:a?.authorizationCode}:{})})).toArray())})}),r}static resolveNodeStatus(e,t){const a=t.split("/");return{name:a.pop()||"",package:a.join("/")}}static parseBindValue(e){return e.startsWith("$")?e.substring(1):e}static async getAccessStatus(e,t,a,r){const i=this.resolveNodeStatus(e,t);if(i.status)return i.status;const s=e.application.getFactoryByName(i.name),n=this.parseBindValue(a),c=s.getOperationByName(n);if(s.authorizedBy||c?.authorizedBy){const t=await access_rights_1.AccessRights.getAuthorizedByAccess(e,s,c,n);if(t)return t.status}return(await context_1.Context.accessRightsManager.getUserAccessFor(e,i.name,n,r)).status}static async getPageAccess(e,t,a){if(a?.pageNode){const t=ClientService.resolveNodeStatus(e,a?.pageNode),r=e.application.getFactoryByName(t.name);if(!await r.isEnabledByServiceOptions(e))return"unavailable"}if(!t)return"authorized";return this.getAccessStatus(e,t.node,t.bind,a)}static async getFactoryAccess(e,t){const{properties:a,queries:r,mutations:i}=t;let s=[];s=(0,lodash_1.union)(s,a.filter(e=>e.isPublished).map(e=>e.name),r.map(e=>e.name),i.map(e=>e.name),runtime_1.standardOperations.map(e=>`$${e}`));const n=await e.user;return e.getCachedValue({category:"ARTIFACT",key:`USER:${n?._id||"*"}:FACTORY:${t.name}`,getValue:async()=>({value:await this.getAccessStatuses(e,{[t.fullName]:s})}),cacheInMemory:true,ttlInSeconds:60})}static async userHasAccessToPage(e,t){const a=await artifact_manager_1.ArtifactManager.getPageArtifact(e,t);if(null==a)return loggers_1.loggers.authorization.error(()=>`${t}: page not found`),false;const r=await ClientService.getPageAccess(e,a.pageAccess,{authorizationCode:a.authorizationCode,pageNode:a.pageNode}),i=(await e.user)?.email;return loggers_1.loggers.authorization.debug(()=>`${t}: access status = ${r}, user = ${i}, page access details = ${a}`),"authorized"===r}static invalidateStorageStatus(){artifact_manager_1.ArtifactManager.clearStored()}}exports.ClientService=ClientService;
//# sourceMappingURL=client-service.js.map