/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ArtifactManager=exports.generateEnumKey=exports.ArtifactDataTypeEnum=void 0,exports.getArtifactDataType=getArtifactDataType;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_shared_1=require("@sage/xtrem-shared"),fs=require("fs/promises"),lodash_1=require("lodash"),minimatch_1=require("minimatch"),path=require("path"),file_utils_1=require("../file-utils"),metadata_schema_utils_1=require("../graphql/metadata-schema/metadata-schema-utils"),core_hooks_1=require("../runtime/core-hooks"),loggers_1=require("../runtime/loggers"),types_1=require("../types"),client_service_1=require("./pages/client-service");var StorageStatus,ArtifactDataTypeEnum;!function(t){t[t.notStarted=0]="notStarted",t[t.done=1]="done"}(StorageStatus||(StorageStatus={})),function(t){t[t.json=1]="json",t[t.js=2]="js",t[t.csv=3]="csv",t[t.ts=4]="ts",t[t.meta=5]="meta"}(ArtifactDataTypeEnum||(exports.ArtifactDataTypeEnum=ArtifactDataTypeEnum={}));const generateEnumKey=t=>{const e=t.split("/");return`${e[0]}/${e[1]}/enums__${(0,lodash_1.snakeCase)(e[2])}`};function pathExtname(t){const e=path.extname(t);return e?`${pathExtname(path.basename(t,e))}${e}`:e}async function readArtifactContent(t){return types_1.TextStream.fromString(await fs.readFile(t,"utf-8"))}function getArtifactDataType(t){switch(pathExtname(t)){case".csv":return"csv";case".json":return"json";case".ts":return"ts";case".meta.json":return"meta";case".js":return"js"}return}exports.generateEnumKey=generateEnumKey;class ArtifactManager{static{this.progress=StorageStatus.notStarted}static{this._applicationArtifactsByType=Object.create(null)}static{this._packArtifactByKey=Object.create(null)}static{this.ensureArtifactsCachedFunnel=(0,xtrem_async_helper_1.funnel)(1)}static clearStored(){this._applicationArtifactsByType=Object.create(null),this.progress=StorageStatus.notStarted}static async ensureArtifactsCached(t){if(this.progress===StorageStatus.done)return;await this.ensureArtifactsCachedFunnel(async()=>{if(this.progress!==StorageStatus.done){const e=[client_service_1.ClientArtifactType.stickers,client_service_1.ClientArtifactType.pages,client_service_1.ClientArtifactType.pageExtensions,client_service_1.ClientArtifactType.pageFragments,client_service_1.ClientArtifactType.widgets];await(0,xtrem_async_helper_1.asyncArray)(e).forEach(e=>this.cacheArtifacts(t,e)),this.progress=StorageStatus.done}})}static async cacheArtifacts(t,e){this._applicationArtifactsByType[e]=this._applicationArtifactsByType[e]??{},await(0,xtrem_async_helper_1.asyncArray)(await this.readClientArtifactsFromFiles(t.application,e)).forEach(a=>this.cacheArtifact(t,e,a))}static cacheArtifact(t,e,a,r){const s=a?.key||r;if(!s)throw new xtrem_shared_1.SystemError(`Cannot store artifact of type ${e}: no key provided`);if(this._applicationArtifactsByType[e]=this._applicationArtifactsByType[e]??{},this._applicationArtifactsByType[e][s]=a,a){const t=this.getPackArtifactInterface(a);this._packArtifactByKey[`${a.packageName}${a.artifactFilePath}`]=t}}static getPackArtifactInterface(t){const e=getArtifactDataType(t.artifactFilePath);return{packageName:t.packageName,path:t.artifactFilePath,content:t.content,dataType:e,type:t.type}}static getArtifactTitle(t,e,a){const r=path.dirname(a.key),s=(0,xtrem_i18n_1.getLocaleFromHeader)(t.request.headers),i=`${(0,lodash_1.kebabCase)(a.key.replace(/^.*[\\/]/,""))}.js`;return e!==client_service_1.ClientArtifactType.strings&&!e.endsWith("extensions")?(0,xtrem_i18n_1.getLiteral)(`${r}/${e}__${(0,lodash_1.snakeCase)(path.parse(i).name)}____title`,s).content:""}static getArtifactDescription(t,e,a){const r=path.dirname(a.key),s=(0,xtrem_i18n_1.getLocaleFromHeader)(t.request.headers),i=`${(0,lodash_1.kebabCase)(a.key.replace(/^.*[\\/]/,""))}.js`;try{return e!==client_service_1.ClientArtifactType.strings&&!e.endsWith("extensions")?(0,xtrem_i18n_1.getLiteral)(`${r}/${e}__${(0,lodash_1.snakeCase)(path.parse(i).name)}____description`,s).content:""}catch{return""}}static addUsedStringsKey(t,e){if(!t)return;let a=e.length;const r=t.strings;if(null!=r)for(const t of r)e[a++]=t;const s=t.enums;if(null!=s)for(const t of s)e[a++]=(0,exports.generateEnumKey)(t)}static async resolveArtifactStrings(t,e,a){const r=[];if(this.addUsedStringsKey(a.literals,r),e===client_service_1.ClientArtifactType.pages){const e=await ArtifactManager.getExtensionsForPage(t,a.key,client_service_1.ClientArtifactType.pages);for(const t of e)this.addUsedStringsKey(t.literals,r);const s=await this.getArtifactPageFragments(t,a);Object.values(s).forEach(t=>{this.addUsedStringsKey(t.literals,r)})}if(a.plugins)for(const t of a.plugins)r.push(t);const s=(0,xtrem_i18n_1.getLocaleFromHeader)(t.request.headers),i=[],c=(0,lodash_1.uniq)(r);for(const t of c)(0,xtrem_i18n_1.appendLiterals)(t,s,i);return i}static async getArtifacts(t,e,a){return(0,xtrem_async_helper_1.asyncArray)(await this.getJsBundles(t,a,e)).map(a=>this.completeWithJsonMeta(t,e,a)).toArray()}static async getJsBundles(t,e,a){const r=path.join("lib",a||"").replace(/\\/g,"/"),s={...e,dataType:"js",condition:t=>a?t.path.startsWith(r):true},i=await this.queryPackArtifacts(t,s),convertToPackArtifact=t=>{const e=(0,lodash_1.camelCase)(t.path.replace(/^.*[\\/]/,"").replace(/\.[^/.]+$/,"")),a=`${e.charAt(0).toUpperCase()}${e.slice(1)}`,r=`${t.packageName}/${a}`;if(!types_1.TextStream.isTextStream(t.content))throw new xtrem_shared_1.SystemError(`artifact '${t.packageName}/${t.path}' must be of type 'TextStream', got '${t.content.constructor.name}'`);const s=t.content;return{packageName:t.packageName,artifactFilePath:t.path,type:t.type,content:s,className:a,key:r}};return i.map(t=>convertToPackArtifact(t))}static async completeWithJsonMeta(t,e,a){const r={packageName:a.packageName,path:a.artifactFilePath.replace(".js",".meta.json")},s=await this.getMetaBundles(t,e,r);if(1!==s.length)throw new Error(`Couldn't identify meta data for the artifact ${a.key} packageName:${a.packageName} path:${a.artifactFilePath}`);return{...a,...s[0]}}static getParsedContent(t){if(types_1.TextStream.isTextStream(t.content))t.content=JSON.parse(t.content.toString());return t.content}static resolvePageCustomizableNodesWizard(t,e){return e.pageNode?t.application.tryToGetFactoryByName((0,types_1.getNameWithoutPackage)(e.pageNode))?.getVitalTree().filter(t=>t.isCustomizable).map(t=>({node:t.name,fullName:t.fullName})):void 0}static async resolvePageCustomizableNodes(t,e){return(await this.getArtifactNodes(t,e)).map(t=>({node:(0,types_1.getNameWithoutPackage)(t),fullName:t})).filter(e=>t.application.tryToGetFactoryByName(e.node)?.isCustomizable)}static async resolvePageCustomFields(t,e){const a=await this.resolvePageCustomizableNodes(t,e);let r;const s=a.length>0?await core_hooks_1.CoreHooks.customizationManager.getCustomFields(t,a?.map(t=>t.fullName)||[],{includeMutableChildren:true}):void 0;if(s)r=Object.keys(s).map(t=>({name:t,properties:s[t]}));return r}static async resolvePageExportTemplatesByNode(t,e){const a=await this.getArtifactNodes(t,e),r=await core_hooks_1.CoreHooks.importExportManager.getNodeExportTemplates(t,a);return Object.keys(r).map(t=>({name:t,exportTemplates:r[t]}))}static async resolveHasRecordPrintingTemplates(t,e){const a=core_hooks_1.CoreHooks.createPrintingManager(t);return await(a?.hasRecordPrintingTemplates?.(e.key))??false}static async resolvePageAccess(t,e){return client_service_1.ClientService.getPageAccess(t,e.pageAccess,{authorizationCode:e.authorizationCode,pageNode:e.pageNode})}static async resolveAccess(t,e){const a=await this.getArtifactNodes(t,e);let r=[],s=false;if(await(0,xtrem_async_helper_1.asyncArray)((0,metadata_schema_utils_1.expandNodeNames)(t.application,a.map(types_1.getNameWithoutPackage),3)).forEach(async e=>{const a=t.application.tryToGetFactoryByName(e);if(a){if(a.hasAttachments)s=true;const e=await client_service_1.ClientService.getFactoryAccess(t,a);r=(0,lodash_1.union)(r,e)}}),s){const e=core_hooks_1.CoreHooks.getAttachmentManager().getAttachmentNode(),a=t.application.factoriesManager.getFactoryByConstructor(e),s=await client_service_1.ClientService.getFactoryAccess(t,a);r=(0,lodash_1.union)(r,s)}return r}static convertToPackArtifact(t,e,a){const r=this.getParsedContent(e),s=path.parse(e.path.replace(".meta.json",".js")).name;let i;try{i=(0,lodash_1.trim)(t.localize(`${e.packageName}/${a}__${(0,lodash_1.snakeCase)(s)}____title`,""))}catch{}const c=r.pageNode&&(0,types_1.getNameWithoutPackage)(r.pageNode)||"",n=t.application.tryToGetFactoryByName(c),o=n?.properties.filter(t=>t.duplicateRequiresPrompt).map(t=>t.name);return{title:i||(0,lodash_1.startCase)(s),authorizationCode:r?.authorizationCode,pageAccess:r?.pageAccess,pageNode:r?.pageNode,extensionAccess:r?.extensionAccess,description:r?.description,listIcon:r?.listIcon,category:r?.category,type:e.type??r?.type,extends:r?.extends,plugins:r?.plugins,literals:r?.literals,menuItem:r?.menuItem,nodes:r?.nodes,duplicateBindings:o,fragments:r?.fragments,group:r?.group}}static async getMetaBundles(t,e,a){return(await this.queryPackArtifacts(t,{...a,dataType:"meta"})).map(a=>this.convertToPackArtifact(t,a,e))}static async getPageArtifact(t,e){return await this.getArtifact(t,e,client_service_1.ClientArtifactType.pages)}static async getArtifact(t,e,a){if(!e)return null;this._applicationArtifactsByType[a]=this._applicationArtifactsByType[a]??{};const r=this._applicationArtifactsByType[a];if(void 0===r[e]){const r=await this.readClientArtifact(t,a,{exactMatch:false,packageOrPage:e});this.cacheArtifact(t,a,r,e)}return r[e]}static async listAllClientArtifactsFromStorage(t,e){await ArtifactManager.ensureArtifactsCached(t);return[...await ArtifactManager.getPackArtifacts(t,e)]}static async getPackArtifacts(t,e){let a=[];const r=(await t.getActivePackageNames()).sort();return await(0,xtrem_async_helper_1.asyncArray)(r).forEach(async r=>{const s={packageName:r};a=a.concat(await this.getArtifacts(t,e,s))}),a}static async readClientArtifact(t,e,a){const r=`${(0,lodash_1.kebabCase)(a.packageOrPage.replace(/^.*[\\/]/,""))}.js`,s=path.join("lib",e,r).replace(/\\/g,"/"),i=path.dirname(a.packageOrPage);await ArtifactManager.ensureArtifactsCached(t);const c={packageName:i,path:s,dataType:"js"},n=(await ArtifactManager.getArtifacts(t,e,c)).filter(t=>!a.pageNode||t.pageNode===a.pageNode);if(n.length)return n[0];return null}static async getExtensionsForPage(t,e,a){if(a!==client_service_1.ClientArtifactType.pages)throw new Error("Extensions only supported for pages");const r=await t.user;return t.getCachedValue({category:"ARTIFACT",key:`USER:${r?._id||"*"}:EXTENSIONS:${e}`,getValue:async()=>({value:await this.getArtifactExtensions(t,e,a)}),cacheInMemory:true,ttlInSeconds:1800})}static async getArtifactExtensions(t,e,a){if(a!==client_service_1.ClientArtifactType.pages)throw new Error(`Extensions only supported for pages, and not ${a} (${e})`);const r=[],s=await t.getActivePackageNames();return await(0,xtrem_async_helper_1.asyncArray)(s).forEach(async a=>{const s=await this.getArtifacts(t,client_service_1.ClientArtifactType.pageExtensions,{packageName:a});await(0,xtrem_async_helper_1.asyncArray)(s).forEach(async a=>{if(a.extends===e&&"authorized"===await client_service_1.ClientService.getPageAccess(t,a?.extensionAccess,{authorizationCode:a?.authorizationCode,pageNode:a?.pageNode}))r.push(a)})}),r}static async getArtifactPageFragments(t,e){const a=this._applicationArtifactsByType[client_service_1.ClientArtifactType.pageFragments]||{};let r=e.fragments||[];return(await this.getArtifactExtensions(t,e.key,e.type)).forEach(t=>{if(t.fragments)r=(0,lodash_1.union)(r,t.fragments)}),r.reduce((t,e)=>{const r=a[e];if(null==r)throw new Error(`Fragment ${e} not found`);return t[e]=r,t},{})}static async getArtifactNodes(t,e){let a=[...e.nodes||[]];const r=await ArtifactManager.getArtifactPageFragments(t,e);Object.values(r).forEach(t=>{if(t.nodes)a=(0,lodash_1.union)(a,t.nodes)});return(await ArtifactManager.getArtifactExtensions(t,e.key,client_service_1.ClientArtifactType.pages)).forEach(t=>{if(t.nodes)a=(0,lodash_1.union)(a,t.nodes)}),a}static async queryPackArtifacts(t,e){await this.ensureArtifactsCached(t);return Object.values(this._packArtifactByKey).filter(t=>(null==e.packageName||e.packageName===t.packageName)&&(null==e.path||e.path===t.path)&&(null==e.dataType||e.dataType===t.dataType)&&("function"!=typeof e.condition||e.condition(t)))}static checkArtifactWithConfig(t){const e=xtrem_config_1.ConfigManager.current.ui;if(null!=e){if(e.exclude&&e.exclude.some(e=>(0,minimatch_1.minimatch)(t,e)))return loggers_1.loggers.application.debug(()=>`Not loading artifact ${t} as per exclusion config`),false;if(e.include){if(e.include.some(e=>(0,minimatch_1.minimatch)(t,e)))return loggers_1.loggers.application.debug(()=>`Loading artifact ${t} as per inclusion config`),true;return loggers_1.loggers.application.debug(()=>`Not loading artifact ${t} as per inclusion config`),false}}return true}static async readClientArtifactsFromFiles(t,e){const a=[];return await(0,xtrem_async_helper_1.asyncArray)(t.getPackages()).forEach(async t=>{const r=path.resolve(t.dir,path.join("build","lib",e));if(await(0,file_utils_1.fileExists)(r)){let s=await fs.readdir(r);s=s.filter(t=>t.endsWith(".meta.json")),await(0,xtrem_async_helper_1.asyncArray)(s).filter(t=>this.checkArtifactWithConfig(path.join(r,t.replace(".meta.json",".js")))).forEach(async s=>{const i=s.replace(".meta.json",".js");if(await(0,file_utils_1.fileExists)(path.resolve(r,i))){const i=path.resolve(r,s),c=JSON.parse(await fs.readFile(i,"utf-8")),addArtifact=async s=>{const i=path.resolve(r,s),n=path.join("lib",e,s).replace(/\\/g,"/");a.push({...c,packageName:t.name,content:await readArtifactContent(i),key:`${t.name}/${c.className}`,artifactFilePath:n,type:e})};await addArtifact(s),await addArtifact(s.replace(".meta.json",".js"))}})}}),a}}exports.ArtifactManager=ArtifactManager;
//# sourceMappingURL=artifact-manager.js.map