/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.postgreSqlToXtrem=exports.xtremToPostgreSql=void 0,exports.getEncryptedStringStorageSize=getEncryptedStringStorageSize,exports.getSqlSerialSequence=getSqlSerialSequence,exports.getSqlCurrvalOfIdSequence=getSqlCurrvalOfIdSequence,exports.getColumnSqlDefaultClause=getColumnSqlDefaultClause,exports.parseColumnDefinition=parseColumnDefinition,exports.getPostgreSqlType=getPostgreSqlType,exports.getColumnDefaultValue=getColumnDefaultValue;const xtrem_postgres_1=require("@sage/xtrem-postgres"),sql_context_1=require("../sql-context/sql-context");function getEncryptedStringStorageSize(e){return 1+2*(16+e)}function getSqlSerialSequence(e){return`(pg_get_serial_sequence('${e}'::text, '_id'::text))::regclass`}function getSqlCurrvalOfIdSequence(e){return`currval(${getSqlSerialSequence(e)})`}function getColumnSqlDefaultClause(e,t){const l=t??getPostgreSqlType(e),n=getColumnDefaultValue(l.name);if("SERIAL8"!==l.name&&"BYTEA"!==l.name&&"TEXT"!==l.name&&!l.isEnum&&(null!==e.default||null!==n))return e.default?e.default:n;return}function parseColumnDefinition(e,t,l,n){const r={columnName:"",typeName:"",nullable:""},u=getPostgreSqlType(l);if(!u)throw new Error(`Column ${t}.${l.name}: unknown column type ${l.colType}`);if(r.columnName=sql_context_1.SqlContext.escape(l.name),r.typeName=u.isEnum?`${e}.${u.name}`:u.name,u.typeNotation)r.typeName=`${r.typeName}${u.typeNotation}`;if(r.default=getColumnSqlDefaultClause(l,u),n?.skipConstraints);else if(!l.isNullable)r.nullable="NOT NULL";return r}function getPostgreSqlType(e){let t,l="",n=false;switch(e.type){case"string":{let t=e.maxLength?e.maxLength:255;if(e.isEncryptedString)t=getEncryptedStringStorageSize(t);l=`(${t}) COLLATE "und-x-icu"`;break}case"decimal":l=`(${xtrem_postgres_1.decimalColumnPrecision},${xtrem_postgres_1.decimalColumnScale})`;break;case"time":l=`(${e.precision||0})`}if(e.isAutoIncrement)t="SERIAL8";else t=exports.xtremToPostgreSql[e.type].type;if("enum"===e.type)t=e.enumDataType.name,n=true;if("enumArray"===e.type)t=`_${e.enumDataType.name}`,n=true;return{name:t,typeNotation:l,isEnum:n}}function getColumnDefaultValue(e){if("SERIAL8"===e)return 0;return exports.postgreSqlToXtrem[e]?.default}exports.xtremToPostgreSql={boolean:{type:"BOOL",default:null},enum:{type:"INT2",default:null},short:{type:"INT4",default:null},reference:{type:"INT8",default:null},integer:{type:"INT8",default:null},integerRange:{type:"INT8RANGE",default:null},decimalRange:{type:"NUMRANGE",default:null},date:{type:"DATE",default:null},dateRange:{type:"DATERANGE",default:null},datetimeRange:{type:"TSTZRANGE",default:null},time:{type:"TIME",default:null},datetime:{type:"TIMESTAMPTZ(3)",default:null},float:{type:"FLOAT4",default:null},decimal:{type:"NUMERIC",default:null},double:{type:"FLOAT8",default:null},binaryStream:{type:"BYTEA",default:"''"},textStream:{type:"TEXT",default:"''"},string:{type:"VARCHAR",default:"''"},uuid:{type:"UUID",default:null},byte:{type:"INT2",default:null},binary:{type:"BYTEA",default:null},json:{type:"JSONB",default:null},integerArray:{type:"_INT8",default:null},enumArray:{type:"_INT2",default:null},referenceArray:{type:"_INT8",default:null},stringArray:{type:"_VARCHAR",default:null}},exports.postgreSqlToXtrem={},Object.keys(exports.xtremToPostgreSql).forEach(e=>{const t=exports.xtremToPostgreSql[e];exports.postgreSqlToXtrem[t.type]={name:e,default:t.default}}),exports.postgreSqlToXtrem.TIMESTAMP={name:"datetime",default:null},exports.postgreSqlToXtrem.TSRANGE={name:"datetimeRange",default:null},exports.postgreSqlToXtrem["TIMESTAMPTZ(6)"]={name:"datetime",default:null};
//# sourceMappingURL=types-conversion.js.map