/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.RestrictDeleteForReferenceArraysTriggerBuilder=void 0;const trigger_builder_1=require("./trigger-builder");class RestrictDeleteForReferenceArraysTriggerBuilder extends trigger_builder_1.TriggerBuilder{constructor(e,r){super("restrict_delete_for_reference_arrays",{when:"AFTER",event:"DELETE",options:e}),this.tablesByColumn=r}get useDedicatedFunction(){return true}getSqlToCreateDedicatedFunction(e){const r=Object.entries(this.tablesByColumn).map(([r,t])=>`SELECT array_agg(_id) INTO referring_ids\nFROM (SELECT _id FROM ${e.schemaName}.${r}\nWHERE OLD._id = ANY(${t}) AND _tenant_id = OLD._tenant_id LIMIT 5);\n            IF array_length(referring_ids, 1) IS NOT NULL THEN\n                RAISE EXCEPTION 'Error: %.%(%) are referencing ${e.tableName}(%)', '${r}', '${t}', referring_ids, OLD._id;\n            END IF;`);return`CREATE OR REPLACE FUNCTION ${this.getFunctionFullname(e)}()\n            RETURNS TRIGGER\n            AS\n            $$\n            DECLARE referring_ids bigint[];\n            BEGIN\n                ${r.join("\n")}\n                RETURN OLD;\n            END;\n            $$\n            LANGUAGE plpgsql;`}}exports.RestrictDeleteForReferenceArraysTriggerBuilder=RestrictDeleteForReferenceArraysTriggerBuilder;
//# sourceMappingURL=restrict-delete-for-reference-arrays-trigger-builder.js.map