/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getNotifyTriggerBuilder=getNotifyTriggerBuilder;const xtrem_shared_1=require("@sage/xtrem-shared"),trigger_builder_1=require("./trigger-builder"),eventTypeByNotificationType={created:"INSERT",updated:"UPDATE",deleted:"DELETE"};class NotifyTriggerBuilder extends trigger_builder_1.TriggerBuilder{constructor(e){super(`notify_${e}`,{when:"AFTER",event:eventTypeByNotificationType[e]}),this.notificationType=e}get useDedicatedFunction(){return true}getSqlToCreateDedicatedFunction(e){if(!e.notify?.event?.[this.notificationType])return;if(e.isSharedByAllTenants)throw new Error(`notification triggers are not supported on shared table ${e.tableName}`);const i=(0,xtrem_shared_1.pascalCase)(e.tableName),t="deleted"===this.notificationType?"OLD":"NEW",r=(e.notify?.sqlPayloadExpression||"").replace(/\{\{ROW\}\}/g,t),n={data:JSON.stringify({topic:this.notificationType})};return`CREATE OR REPLACE FUNCTION ${this.getFunctionFullname(e)}()\n        RETURNS TRIGGER\n        AS\n        $$\n            DECLARE\n                origin_id varchar;\n                notification_id varchar;\n                email varchar;\n                login varchar;\n                all_disabled varchar;\n                tenant_disabled varchar;\n            BEGIN\n                SELECT COALESCE(${e.schemaName}.get_config('xtrem.origin_id'), '') INTO origin_id;\n                SELECT COALESCE(${e.schemaName}.get_config('xtrem.notification.disable.ALL'), 'false') INTO all_disabled;\n                SELECT COALESCE(${e.schemaName}.get_config('xtrem.notification.disable.t_'||${t}._tenant_id), 'false') INTO tenant_disabled;\n                SELECT COALESCE(${e.schemaName}.get_config('xtrem.user_email'), '') INTO email;\n                SELECT COALESCE(${e.schemaName}.get_config('xtrem.login_email'), '') INTO login;\n\n                IF (all_disabled <> 'true' and tenant_disabled <> 'true') THEN\n                    SELECT ${e.schemaName}.nanoid() INTO notification_id;\n                    INSERT INTO ${e.schemaName}.sys_notification\n                        (tenant_id, origin_id, notification_id, reply_id, reply_topic, user_email, login, locale, topic, payload, status, _source_id, _update_tick, _create_stamp, _update_stamp)\n                    VALUES (${t}._tenant_id, origin_id, notification_id, '', '', email, login, '', '${i}/${this.notificationType}',\n                        ${r}, 'pending',\n                        '', 1, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);\n                    NOTIFY notification_queued, '${JSON.stringify(n)}';\n                END IF;\n\n\n                RETURN ${t};\n            END;\n        $$\n        LANGUAGE plpgsql;`}}function getNotifyTriggerBuilder(e){return trigger_builder_1.TriggerBuilder.getBuilder(`notify_${e}`,"AFTER",eventTypeByNotificationType[e])}trigger_builder_1.TriggerBuilder.registerBuilder(new NotifyTriggerBuilder("created")),trigger_builder_1.TriggerBuilder.registerBuilder(new NotifyTriggerBuilder("updated")),trigger_builder_1.TriggerBuilder.registerBuilder(new NotifyTriggerBuilder("deleted"));
//# sourceMappingURL=notify-trigger-builder.js.map