/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.deleteBaseNodeTriggerBuilder=void 0;const trigger_builder_1=require("./trigger-builder");class DeleteBaseNodeTriggerBuilder extends trigger_builder_1.TriggerBuilder{constructor(){super("base_delete",{when:"AFTER",event:"DELETE"})}get useDedicatedFunction(){return true}getSqlToCreateDedicatedFunction(e){if(!e.baseDefinition)throw new Error(`${e.tableName} does not have a base table`);const r=e.baseDefinition.tableName;return`CREATE OR REPLACE FUNCTION ${this.getFunctionFullname(e)}()\n            RETURNS TRIGGER\n            AS\n            $$\n                BEGIN\n                    EXECUTE 'DELETE FROM ${e.schemaName}.${r} WHERE _id = '\n                        || OLD._id${e.isSharedByAllTenants?"":" || ' AND _tenant_id = ''' || OLD._tenant_id || ''''"};\n                    RETURN OLD;\n                END;\n            $$\n            LANGUAGE plpgsql;`}}exports.deleteBaseNodeTriggerBuilder=trigger_builder_1.TriggerBuilder.registerBuilder(new DeleteBaseNodeTriggerBuilder);
//# sourceMappingURL=delete-base-node-trigger-builder.js.map