/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.CascadeDeleteFromReferenceArraysTriggerBuilder=void 0;const trigger_builder_1=require("./trigger-builder");class CascadeDeleteFromReferenceArraysTriggerBuilder extends trigger_builder_1.TriggerBuilder{constructor(e,r){super("cascade_delete_from_reference_arrays",{when:"AFTER",event:"DELETE",options:e}),this.tablesByColumn=r}get useDedicatedFunction(){return true}getSqlToCreateDedicatedFunction(e){const r=Object.entries(this.tablesByColumn).map(([r,t])=>`UPDATE ${e.schemaName}.${r} SET ${t} = array_remove(${t}, OLD._id) WHERE _tenant_id = OLD._tenant_id;`);return`CREATE OR REPLACE FUNCTION ${this.getFunctionFullname(e)}()\n            RETURNS TRIGGER\n            AS\n            $$\n            BEGIN\n                ${r.join("\n")}\n                RETURN OLD;\n            END;\n            $$\n            LANGUAGE plpgsql;`}}exports.CascadeDeleteFromReferenceArraysTriggerBuilder=CascadeDeleteFromReferenceArraysTriggerBuilder;
//# sourceMappingURL=cascade-delete-from-reference-arrays-trigger-builder.js.map