export declare abstract class ColumnInconsistency {
    private readonly _description;
    constructor(_description: string);
    get description(): string;
}
export declare class ColumnInconsistencyNullable extends ColumnInconsistency {
    readonly oldNullableFlag: boolean;
    readonly newNullableFlag: boolean;
    constructor(oldNullableFlag: boolean, newNullableFlag: boolean);
}
/**
 * The SQL default value (int the database) differs to what it should be from the decorators
 */
export declare class ColumnInconsistencyDefaultValue extends ColumnInconsistency {
    constructor(oldDefaultValue?: string, newDefaultValue?: string);
}
export declare class ColumnInconsistencyType extends ColumnInconsistency {
    readonly options: {
        fromType: string;
        toType: string;
        conversionType: string;
    };
    constructor(description: string, options: {
        fromType: string;
        toType: string;
        conversionType: string;
    });
}
//# sourceMappingURL=types.d.ts.map