/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlContext=void 0;const xtrem_config_1=require("@sage/xtrem-config"),runtime_1=require("../../runtime"),loggers_1=require("../../runtime/loggers"),keywords_1=require("../statements/keywords"),database_manager_1=require("./database-manager");class SqlContext{#e;#t;constructor(e,t){this.lockId=e,this.#e=runtime_1.globalRunningContext.isServicesMode?"user":t??"user",this.config=xtrem_config_1.ConfigManager.current.storage.sql}static get logger(){return loggers_1.loggers.sql}withAdvisoryLock(e,t){if(t)return this.withAdvisoryLockCnx(t,e);return this.withConnection(t=>this.withAdvisoryLockCnx(t,e))}async withAdvisoryLockCnx(e,t){const{lockId:o}=this;if(!o)throw new Error("No lock id defined for setting advisory lock in this context");try{return await this.connectionPool.execute(e,`SELECT pg_advisory_lock(${o})`),await t(e)}finally{await this.connectionPool.execute(e,`SELECT pg_advisory_unlock(${o})`)}}get connectionPool(){if(!this.#t)this.#t="sys"===this.#e?database_manager_1.DatabaseManager.getSysPool(this.config):database_manager_1.DatabaseManager.getPool(this.config);return this.#t}execute(e,t,o,n){return this.connectionPool.execute(e,t,o,n)}withConnection(e,t){return this.connectionPool.withConnection(e,t)}createReader(e,t,o,n){return this.connectionPool.createReader(e,t,o,n)}executeSqlStatement(e){return this.withConnection(t=>this.execute(t,e.sql,e.args,e.opts),e.cnx)}get user(){return this.connectionPool.user}static param(e){return`$${e+1}`}static escape(e){if(/[^a-z0-9_]/.test(e))return`"${e}"`;return keywords_1.keywordsRegExp.test(e)?`"${e}"`:e}static isIndexNotFound(e){return/ER_CANT_DROP_FIELD_OR_KEY/.test(e.message)}static isTableNotFound(e){return/ER_NO_SUCH_TABLE/.test(e.message)}static isUniqueViolated(e){return/ER_DUP_ENTRY/.test(e.message)}static isLocked(e){return/ER_LOCK_OR_ACTIVE_TRANSACTION/.test(e.message)}static isNoRecord(e){return/ER_KEY_NOT_FOUND/.test(e.message)}static getFullTableDefName(e){return SqlContext.getFullTableName(e.schemaName,e.tableName)}static getFullTableName(e,t,o){const n=e?`${SqlContext.escape(e)}.${SqlContext.escape(t)}`:`${SqlContext.escape(t)}`;return o?`${n} ${o}`:n}static sqlErrorMessage(e,t){if("violatesForeignKeyConstraint"===e)return`insert or update on table "${t.table}" violates foreign key constraint "${t.foreignKey}": Key (${Object.keys(t.key).join(", ")})=(${Object.values(t.key).join(", ")}) is not present in table "${t?.fkTable}".`;return"Unknown type"}}exports.SqlContext=SqlContext;
//# sourceMappingURL=sql-context.js.map