/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SchemaSqlContext=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),_1=require("."),extensions_1=require("../statements/extensions"),functions_1=require("../statements/functions"),sql_context_1=require("./sql-context");class SchemaSqlContext extends sql_context_1.SqlContext{constructor(e){super(7435141139632913,"sys"),this.application=e}get schemaName(){return this.application.schemaName}createSchema(){return this.executeSqlStatement({sql:`CREATE SCHEMA IF NOT EXISTS ${this.schemaName}`})}dropSchema(e){return this.executeSqlStatement({sql:`DROP SCHEMA IF EXISTS ${e||this.schemaName} CASCADE`})}renameSchema(e,t){return this.executeSqlStatement({sql:`ALTER SCHEMA ${e} RENAME TO ${t}`})}async createFunctions(){await this.withConnection(e=>(0,functions_1.createFunctions)(this.schemaName,t=>this.execute(e,t)))}async createExtensions(){await this.withConnection(e=>(0,extensions_1.createExtensions)(t=>this.execute(e,t)))}tableExists(e){const t="SELECT to_regclass($1);";return this.withConnection(async s=>{const a=await this.execute(s,t,[(this.schemaName?`${this.schemaName}.`:"")+e],{logLevel:"debug"});return!!(a.length&&null!=a[0].to_regclass)})}dropTable(e,t={isCascade:false,errorsAsWarnings:false}){return this.dropTables([e],t)}dropTables(e,t={isCascade:false,errorsAsWarnings:true}){return this.withConnection(async s=>{let a=true;return await(0,xtrem_async_helper_1.asyncArray)(e).forEach(async e=>{const n=sql_context_1.SqlContext.getFullTableName(this.schemaName,e);try{await this.execute(s,`DROP TABLE ${n} ${t.isCascade?" CASCADE ":""}`)}catch(e){if(t.errorsAsWarnings)return sql_context_1.SqlContext.logger.warn(`Could not drop table '${n} : ${e.stack}`),void(a=false);throw e}}),a})}async updateColumnType(e,t,s,a,n){const c=`ALTER TABLE ${this.schemaName}.${e} ALTER COLUMN ${t}`;let r=`${c} TYPE ${s}`;if(n.dropDefault||n.using)await this.executeSqlStatement({sql:`${c} DROP DEFAULT`}),await this.executeSqlStatement({sql:`DROP SEQUENCE IF EXISTS ${this.schemaName}.${e}_${t}_seq`});if(n.using)r=`${r} USING ${n.using}`;r=`${r};${_1.ModifyTableSqlContext.getSqlToComment("column",{schemaName:this.schemaName,tableName:e,columnName:t},a)};`,await this.executeSqlStatement({sql:r})}}exports.SchemaSqlContext=SchemaSqlContext;
//# sourceMappingURL=schema-sql-context.js.map