import { ColumnJsonComment } from '@sage/xtrem-postgres';
import { Application } from '../../application';
import { SqlContext } from './sql-context';
interface DropTableOptions {
    isCascade: boolean;
    errorsAsWarnings: boolean;
}
export declare class SchemaSqlContext extends SqlContext {
    readonly application: Application;
    constructor(application: Application);
    get schemaName(): string;
    createSchema(): Promise<void>;
    dropSchema(schemaName?: string): Promise<void>;
    renameSchema(oldName: string, newName: string): Promise<void>;
    createFunctions(): Promise<void>;
    createExtensions(): Promise<void>;
    /**
     * Verifies that the supplied table name exists in the supplied schema
     * @param name
     */
    tableExists(tableName: string): Promise<boolean>;
    /**
     * Tries to drop a table and returns whether the drop succeeded
     */
    dropTable(name: string, options?: DropTableOptions): Promise<boolean>;
    dropTables(tablesToDrop: string[], options?: DropTableOptions): Promise<boolean>;
    updateColumnType(tableName: string, columnName: string, typeName: string, columnComment: ColumnJsonComment, options: {
        using?: string;
        dropDefault?: boolean;
    }): Promise<void>;
}
export {};
//# sourceMappingURL=schema-sql-context.d.ts.map