/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ModifyTableSqlContext=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),_1=require("."),naming_1=require("../statements/naming"),triggers_1=require("../statements/triggers"),types_conversion_1=require("../statements/types-conversion"),enum_sql_context_1=require("./enum-sql-context"),schema_sql_context_1=require("./schema-sql-context"),sql_context_1=require("./sql-context"),types_1=require("./types");class ModifyTableSqlContext extends schema_sql_context_1.SchemaSqlContext{constructor(e,t){super(e),this.tableDef=t}async createTableFromTableDefinitionWithConnection(e,t={}){if(t.onlyIndexes)t.skipDrop=true,t.skipCreate=true,t.skipSequences=true,t.skipIndexes=false,t.dropTrigger=false,t.skipTriggers=true,t.skipForeignKeys=true;if(!t.skipDrop&&await this.tableExists(this.tableDef.tableName))await this.dropTable(this.tableDef.tableName);if(!t.skipCreate){const a=t.temp?" TEMP":"",s=sql_context_1.SqlContext.getFullTableDefName(this.tableDef);let n=`CREATE${a} TABLE ${t.temp?this.tableDef.tableName:s} (`;if(n+=this.createTableColumns(t),n+=this.createPrimaryKey(),n+=");",!t.skipIndexes)n+=this.createTableIndexes();if(this.tableDef.comment)n=`${n}\n${ModifyTableSqlContext.getSqlToComment("table",{schemaName:this.tableDef.schemaName,tableName:this.tableDef.tableName},this.tableDef.comment)}`;if(this.tableDef.columns?.filter(e=>e.comment).forEach(e=>{n=`${n}\n${ModifyTableSqlContext.getSqlToComment("column",{schemaName:this.tableDef.schemaName,tableName:this.tableDef.tableName,columnName:e.name},e.comment)}`}),!t.skipCommands)await this.execute(e,n)}if(!t.skipForeignKeys){const t=this.getSqlToCreateForeignKeys();await this.execute(e,t)}if(!t.skipTriggers&&!t.skipCommands&&this.tableDef.triggers)await this.createTriggers(this.tableDef.triggers,e)}async createTableFromTableDefinition(e={}){await this.withAdvisoryLock(t=>this.createTableFromTableDefinitionWithConnection(t,e))}async createTemporaryTable(e){if(!e.isWritable)throw new xtrem_shared_1.LogicError("cannot create temporary table: context is not writable");await this.createTableFromTableDefinitionWithConnection(e.transaction.connection,{skipTriggers:true,skipDefault:true,temp:true})}async giveUserRightsToTable(e){try{await this.executeSqlStatement({sql:`GRANT DELETE, INSERT, UPDATE, SELECT on ${sql_context_1.SqlContext.escape(this.schemaName)}.${this.tableName} to ${sql_context_1.SqlContext.escape(e)}`}),await(0,xtrem_async_helper_1.asyncArray)(this.tableDef.columns||[]).filter(e=>!!e.isAutoIncrement).forEach(async t=>{const a=`GRANT USAGE, SELECT ON SEQUENCE ${sql_context_1.SqlContext.escape(this.schemaName)}.${sql_context_1.SqlContext.escape(`${this.tableDef.tableName}_${t.name}_seq`)} TO ${sql_context_1.SqlContext.escape(e)}`;await this.executeSqlStatement({sql:a})})}catch(t){sql_context_1.SqlContext.logger.error(`[${this.user}] Could not give access rights to ${e} on "${this.schemaName}"."${this.tableName}" : ${t.message}\n${t.stack}`)}}async createTriggers(e,t){if(0===e.length)return;await this.withAdvisoryLock(async t=>{const a=[];e.forEach(e=>{const t=triggers_1.TriggerBuilder.getBuilderForTrigger(e);if(t.useDedicatedFunction){const s=t.getSqlToCreateDedicatedFunction(this.tableDef);if(!s)throw new Error(`The trigger ${e} does not provide any source for its dedicated function.`);a.push(s)}const s=t.getSqlToCreateTrigger(this.tableDef);a.push(s)}),await this.execute(t,a.join("\n"),[],{logLevel:"verbose"})},t)}async dropTriggers(e,t){await this.withAdvisoryLock(async t=>{const a=[];e.forEach(e=>{const t=triggers_1.TriggerBuilder.getBuilderForTrigger(e);a.push(t.getSqlToDrop(this.tableDef))}),await this.execute(t,a.join("\n"),[],{logLevel:"verbose"})},t)}async createIndex(e){await this.executeSqlStatement({sql:`${this.getSqlToCreateIndexFunctions([e])}${this.getSqlToCreateIndex(e)}`})}async dropIndex(e){await this.executeSqlStatement({sql:this.getSqlToDropIndex(e)})}async addColumns(e,t){await this.executeSqlStatement({sql:this.getSqlToAddColumns(e,t)})}async alterColumns(e){const t=this.getSqlToAlterColumns(e);if(0===t.length)return;await this.executeSqlStatement({sql:t})}async dropColumns(e){await this.executeSqlStatement({sql:this.getSqlToDropColumns(e)})}async renameForeignKey(e,t){await this.executeSqlStatement({sql:this.getSqlToRenameForeignKey(e,t)})}async addForeignKey(e,t){await this.executeSqlStatement({sql:this.getSqlToCreateForeignKey(e,t)})}async dropForeignKey(e){await this.executeSqlStatement({sql:this.getSqlToDropForeignKey(e)})}get tableName(){return sql_context_1.SqlContext.escape(this.tableDef.tableName)}createTableColumns(e){if(!this.tableDef.columns)return"";return this.tableDef.columns.map(t=>this.getSqlToAddColumn(t,e)).join(", ")}createPrimaryKey(){const e=this.tableDef;let t="";if(e.primaryKey)t=`,CONSTRAINT ${sql_context_1.SqlContext.escape((0,naming_1.makeName63)(`${e.tableName}_PK`))} PRIMARY KEY(${e.primaryKey.columns.map(e=>sql_context_1.SqlContext.escape(e)).join()})`;else throw new Error("Primary key not supplied in table definition");return t}static getSqlToComment(e,t,a){switch(e){case"table":return`COMMENT ON TABLE ${t.schemaName}.${t.tableName} IS '${JSON.stringify(a,null,"  ")}';`;case"column":return`COMMENT ON COLUMN ${t.schemaName}.${t.tableName}.${t.columnName} IS '${JSON.stringify(a,null,"  ")}';`;case"foreignKey":return`COMMENT ON CONSTRAINT ${t.fkName} ON ${t.schemaName}.${t.tableName} IS '${JSON.stringify(a,null,"  ")}';`;default:throw new Error(`Invalid object type to comment ${e}`)}}getSqlToRenameForeignKey(e,t){return`ALTER TABLE ${this.schemaName}.${this.tableName} RENAME CONSTRAINT "${e}" TO "${t}"`}getSqlToCreateForeignKey(e,t){let a;switch(e.onDeleteBehaviour){case"cascade":a=" ON DELETE CASCADE DEFERRABLE";break;case"restrict":a=" ON DELETE RESTRICT DEFERRABLE";break;case"noAction":a=" ON DELETE NO ACTION";break;default:throw new Error(`Unmanaged 'onDelete' behaviour : ${e.onDeleteBehaviour}`)}const s=t?.withUpdateCascade?" ON UPDATE CASCADE":"",n=e.isDeferrable?" DEFERRABLE":"";let i=`ALTER TABLE ${this.schemaName}.${this.tableName} ADD CONSTRAINT "${e.name}" FOREIGN KEY(${e.columnNames.map(e=>sql_context_1.SqlContext.escape(e)).join()}) REFERENCES ${this.schemaName}.${e.targetTable}(${e.targetColumnNames.map(e=>sql_context_1.SqlContext.escape(e)).join()})${a}${s}${n};`;if(e.comment)i=`${i}\n${ModifyTableSqlContext.getSqlToComment("foreignKey",{schemaName:this.schemaName,tableName:this.tableName,fkName:e.name},e.comment)};`;return i}getSqlToCreateForeignKeys(e){let t="";if(this.tableDef.foreignKeys)this.tableDef.foreignKeys.forEach(a=>{t+=this.getSqlToCreateForeignKey(a,e)});return t}createTableIndexes(){if(!this.tableDef.indexes)return"";return`${this.getSqlToCreateIndexFunctions(this.tableDef.indexes)}${this.tableDef.indexes.map(e=>this.getSqlToCreateIndex(e)).join("\n")}`}getSqlToCreateIndexFunctions(e){const t=new Set;e.forEach(e=>e.columns.filter(e=>e.expression).forEach(e=>t.add(e)));const a=Array.from(t),s=new Set;if(a.forEach(e=>{const t=this.tableDef.columns?.find(t=>t.name===e.name),a=t?.enumDataType?.name;if(a)s.add(a)}),s.size>0)return Array.from(s).map(e=>enum_sql_context_1.EnumSqlContext.getSqlToCreateEnumCoalesceFunction(this.schemaName,e)).join("\n");return""}getSqlToAddColumn(e,t){const a=(0,types_conversion_1.parseColumnDefinition)(this.schemaName,this.tableName,e,t);let s=`${a.columnName} ${a.typeName}`;if(!t?.skipDefault&&a.default){const e=t?.deferredSql;if(e&&/\bcurrval\(/.test(a.default))this.computeDeferredDefaultSql(a.columnName,a.default,e);else s=`${s} DEFAULT ${a.default}`}if(a.nullable)s=`${s} ${a.nullable}`;return t?.isAltering?`ADD COLUMN IF NOT EXISTS ${s}`:s}computeDeferredDefaultSql(e,t,a){a.alterColumns=a.alterColumns??[],a.alterColumns.push(`ALTER COLUMN ${e} SET DEFAULT ${t}`),a.updateColumns=a.updateColumns??[];const s=/currval\(\(pg_get_serial_sequence\('([a-z_][a-z0-9_.]*)'::text, '_id'::text\)\)::regclass\)(.*)/.exec(t.startsWith("(")?t.slice(1,-1):t);if(!s)throw new Error(`Unhandled currval expression in DEFAULT constraint: ${t}`);const[n,i]=s.slice(1),o=`UPDATE ${this.schemaName}.${this.tableName} AS t0 SET ${e}`;if(n===`${this.schemaName}.${this.tableName}`)a.updateColumns.push(`${o}=_id ${i} WHERE ${e} IS NULL;`);else{const t=this.tableDef.isSharedByAllTenants?"":"AND t0._tenant_id = t1._tenant_id";a.updateColumns.push(`${o}=(SELECT _id ${i} FROM ${n} as t1 WHERE t0._id = t1._id ${t}) WHERE ${e} IS NULL;`)}}getSqlToAlterColumn(e,t,a){const s=(0,types_conversion_1.parseColumnDefinition)(this.schemaName,this.tableName,e,a);return t.map(t=>{if(t instanceof types_1.ColumnInconsistencyNullable)return`ALTER COLUMN ${s.columnName} ${t.oldNullableFlag?"SET NOT NULL":"DROP NOT NULL"}`;if(t instanceof _1.ColumnInconsistencyDefaultValue)return`ALTER COLUMN ${s.columnName} ${s.default?`SET DEFAULT ${s.default}`:"DROP DEFAULT"}`;throw new Error(`Unmanaged inconsistency on column ${this.tableName}.${e.name}: ${t.description}`)}).filter(e=>!!e).join(", ")}getSqlToAddColumns(e,t){const a=t?.tableNameToUse||this.tableName,s={},n=[`ALTER TABLE ${this.schemaName}.${a} ${e.map(e=>this.getSqlToAddColumn(e,{isAltering:true,skipConstraints:t?.skipConstraints,deferredSql:s})).join(", ")};`],{alterColumns:i,updateColumns:o}=s;if(o&&o.length>0)n.push(...o);if(i&&i.length>0)n.push(`ALTER TABLE ${this.schemaName}.${a} ${i.join(", ")};`);return n.push(...e.filter(e=>!!e.comment).map(e=>ModifyTableSqlContext.getSqlToComment("column",{schemaName:this.schemaName,tableName:a,columnName:e.name},e.comment))),n.join("\n")}getSqlToAlterColumns(e){const t=e.map(e=>this.getSqlToAlterColumn(e.definition,e.inconsistencies,{skipConstraints:false})).filter(e=>!!e);if(0===t.length)return"";return`ALTER TABLE ${this.schemaName}.${this.tableName} ${t.join(", ")};`}getSqlToDropColumns(e){return`ALTER TABLE ${this.schemaName}.${this.tableName} ${e.map(e=>`DROP COLUMN IF EXISTS ${e}`).join(", ")};`}getSqlToDropForeignKey(e){return`ALTER TABLE ${this.schemaName}.${this.tableName} DROP CONSTRAINT IF EXISTS ${e};`}getSqlToCreateIndex(e){return`CREATE ${e.isUnique?"UNIQUE":""} INDEX ${e.name} ON ${this.schemaName}.${this.tableName}(${e.columns.map(e=>`${e.expression||sql_context_1.SqlContext.escape(e.name)} ${e.ascending?"ASC":"DESC"}`).join()});`}getSqlToDropIndex(e){return`DROP INDEX IF EXISTS ${this.schemaName}.${sql_context_1.SqlContext.escape(e)};`}}exports.ModifyTableSqlContext=ModifyTableSqlContext;
//# sourceMappingURL=modify-table-sql-context.js.map